/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rebuild;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DDLSemanticAnalyzerFactory.DDLType(types={831})
public class AlterMaterializedViewRebuildAnalyzer
extends CalcitePlanner {
    private static final Logger LOG = LoggerFactory.getLogger(AlterMaterializedViewRebuildAnalyzer.class);
    private static final String REWRITTEN_INSERT_STATEMENT = "INSERT OVERWRITE TABLE %s %s";

    public AlterMaterializedViewRebuildAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (this.mvRebuildMode != SemanticAnalyzer.MaterializationRebuildMode.NONE) {
            super.analyzeInternal(root);
            return;
        }
        ASTNode tableTree = (ASTNode)root.getChild(0);
        TableName tableName = AlterMaterializedViewRebuildAnalyzer.getQualifiedTableName(tableTree);
        if (this.ctx.isScheduledQuery()) {
            this.unparseTranslator.addTableNameTranslation(tableTree, SessionState.get().getCurrentDatabase());
            return;
        }
        try {
            Boolean outdated = this.db.isOutdatedMaterializedView(this.getTxnMgr(), tableName);
            if (outdated != null && !outdated.booleanValue()) {
                String msg = String.format("Materialized view %s.%s is up to date. Skipping rebuild.", tableName.getDb(), tableName.getTable());
                LOG.info(msg);
                this.console.printInfo(msg, false);
                return;
            }
        }
        catch (HiveException e) {
            LOG.warn("Error while checking materialized view " + tableName.getDb() + "." + tableName.getTable(), (Throwable)e);
        }
        ASTNode rewrittenAST = this.getRewrittenAST(tableName);
        this.mvRebuildMode = SemanticAnalyzer.MaterializationRebuildMode.INSERT_OVERWRITE_REBUILD;
        this.mvRebuildDbName = tableName.getDb();
        this.mvRebuildName = tableName.getTable();
        LOG.debug("Rebuilding materialized view " + tableName.getNotEmptyDbTable());
        super.analyzeInternal(rewrittenAST);
        this.queryState.setCommandType(HiveOperation.ALTER_MATERIALIZED_VIEW_REBUILD);
    }

    private ASTNode getRewrittenAST(TableName tableName) throws SemanticException {
        ASTNode rewrittenAST;
        block7: {
            try {
                LockState state;
                Table table = this.getTableObjectByName(tableName.getNotEmptyDbTable(), true);
                if (!table.isMaterializedView()) {
                    throw new SemanticException(ErrorMsg.REBUILD_NO_MATERIALIZED_VIEW, new String[0]);
                }
                String viewText = table.getViewExpandedText();
                if (viewText.trim().isEmpty()) {
                    throw new SemanticException(ErrorMsg.MATERIALIZED_VIEW_DEF_EMPTY, new String[0]);
                }
                Context ctx = new Context((Configuration)this.queryState.getConf());
                String rewrittenInsertStatement = String.format(REWRITTEN_INSERT_STATEMENT, tableName.getEscapedNotEmptyDbTable(), viewText);
                rewrittenAST = ParseUtils.parse(rewrittenInsertStatement, ctx);
                this.ctx.addSubContext(ctx);
                if (this.ctx.isExplainPlan() || !AcidUtils.isTransactionalTable(table)) break block7;
                HiveTxnManager txnManager = this.getTxnMgr();
                try {
                    state = txnManager.acquireMaterializationRebuildLock(tableName.getDb(), tableName.getTable(), txnManager.getCurrentTxnId()).getState();
                }
                catch (LockException e) {
                    throw new SemanticException("Exception acquiring lock for rebuilding the materialized view", (Throwable)((Object)e));
                }
                if (state != LockState.ACQUIRED) {
                    throw new SemanticException("Another process is rebuilding the materialized view " + tableName.getNotEmptyDbTable());
                }
            }
            catch (Exception e) {
                throw new SemanticException((Throwable)e);
            }
        }
        return rewrittenAST;
    }
}

