/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.create;

import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.view.create.CreateViewDesc;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.StorageFormat;

public class CreateViewOperation
extends DDLOperation<CreateViewDesc> {
    public CreateViewOperation(DDLOperationContext context, CreateViewDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table oldview = this.context.getDb().getTable(((CreateViewDesc)this.desc).getViewName(), false);
        if (oldview != null) {
            boolean isReplace = ((CreateViewDesc)this.desc).isReplace();
            if (((CreateViewDesc)this.desc).getReplicationSpec().isInReplicationScope()) {
                if (((CreateViewDesc)this.desc).getReplicationSpec().allowEventReplacementInto(oldview.getParameters())) {
                    isReplace = true;
                } else {
                    LOG.debug("DDLTask: Create View is skipped as view {} is newer than update", (Object)((CreateViewDesc)this.desc).getViewName());
                    return 0;
                }
            }
            if (!isReplace) {
                if (((CreateViewDesc)this.desc).getIfNotExists()) {
                    return 0;
                }
                throw new HiveException(ErrorMsg.TABLE_ALREADY_EXISTS.getMsg(((CreateViewDesc)this.desc).getViewName()));
            }
            oldview.setViewOriginalText(((CreateViewDesc)this.desc).getOriginalText());
            oldview.setViewExpandedText(((CreateViewDesc)this.desc).getExpandedText());
            oldview.setFields(((CreateViewDesc)this.desc).getSchema());
            if (((CreateViewDesc)this.desc).getComment() != null) {
                oldview.setProperty("comment", ((CreateViewDesc)this.desc).getComment());
            }
            if (((CreateViewDesc)this.desc).getProperties() != null) {
                oldview.getTTable().getParameters().putAll(((CreateViewDesc)this.desc).getProperties());
            }
            oldview.setPartCols(((CreateViewDesc)this.desc).getPartitionColumns());
            oldview.checkValidity(null);
            if (((CreateViewDesc)this.desc).getOwnerName() != null) {
                oldview.setOwner(((CreateViewDesc)this.desc).getOwnerName());
            }
            this.context.getDb().alterTable(((CreateViewDesc)this.desc).getViewName(), oldview, false, null, true);
            DDLUtils.addIfAbsentByName(new WriteEntity(oldview, WriteEntity.WriteType.DDL_NO_LOCK), this.context.getWork().getOutputs());
        } else {
            Table view = this.createViewObject();
            this.context.getDb().createTable(view, ((CreateViewDesc)this.desc).getIfNotExists());
            DDLUtils.addIfAbsentByName(new WriteEntity(view, WriteEntity.WriteType.DDL_NO_LOCK), this.context.getWork().getOutputs());
            LineageInfo.DataContainer dc = new LineageInfo.DataContainer(view.getTTable());
            this.context.getQueryState().getLineageState().setLineage(new Path(((CreateViewDesc)this.desc).getViewName()), dc, view.getCols());
        }
        return 0;
    }

    private Table createViewObject() throws HiveException {
        TableName name = HiveTableName.of(((CreateViewDesc)this.desc).getViewName());
        Table view = new Table(name.getDb(), name.getTable());
        view.setViewOriginalText(((CreateViewDesc)this.desc).getOriginalText());
        view.setViewExpandedText(((CreateViewDesc)this.desc).getExpandedText());
        view.setTableType(TableType.VIRTUAL_VIEW);
        view.setSerializationLib(null);
        view.clearSerDeInfo();
        view.setFields(((CreateViewDesc)this.desc).getSchema());
        if (((CreateViewDesc)this.desc).getComment() != null) {
            view.setProperty("comment", ((CreateViewDesc)this.desc).getComment());
        }
        if (((CreateViewDesc)this.desc).getProperties() != null) {
            view.getParameters().putAll(((CreateViewDesc)this.desc).getProperties());
        }
        if (!CollectionUtils.isEmpty(((CreateViewDesc)this.desc).getPartitionColumns())) {
            view.setPartCols(((CreateViewDesc)this.desc).getPartitionColumns());
        }
        StorageFormat storageFormat = new StorageFormat((Configuration)this.context.getConf());
        storageFormat.fillDefaultStorageFormat(false, false);
        view.setInputFormatClass(storageFormat.getInputFormat());
        view.setOutputFormatClass(storageFormat.getOutputFormat());
        if (((CreateViewDesc)this.desc).getOwnerName() != null) {
            view.setOwner(((CreateViewDesc)this.desc).getOwnerName());
        }
        StatsSetupConst.setStatsStateForCreateTable((Map)view.getTTable().getParameters(), null, (String)"false");
        return view;
    }
}

