/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.create;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.view.create.CreateMaterializedViewDesc;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;

public class CreateMaterializedViewOperation
extends DDLOperation<CreateMaterializedViewDesc> {
    public CreateMaterializedViewOperation(DDLOperationContext context, CreateMaterializedViewDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table oldview = this.context.getDb().getTable(((CreateMaterializedViewDesc)this.desc).getViewName(), false);
        if (oldview != null) {
            if (((CreateMaterializedViewDesc)this.desc).getIfNotExists()) {
                return 0;
            }
            throw new HiveException(ErrorMsg.TABLE_ALREADY_EXISTS.getMsg(((CreateMaterializedViewDesc)this.desc).getViewName()));
        }
        Table tbl = ((CreateMaterializedViewDesc)this.desc).toTable(this.context.getConf());
        if (tbl.isMaterializedView()) {
            CreationMetadata cm = new CreationMetadata(MetaStoreUtils.getDefaultCatalog((Configuration)this.context.getConf()), tbl.getDbName(), tbl.getTableName(), (Set)ImmutableSet.copyOf(((CreateMaterializedViewDesc)this.desc).getTablesUsed()));
            cm.setValidTxnList(this.context.getConf().get("hive.txn.tables.valid.writeids"));
            tbl.getTTable().setCreationMetadata(cm);
        }
        this.context.getDb().createTable(tbl, ((CreateMaterializedViewDesc)this.desc).getIfNotExists());
        DDLUtils.addIfAbsentByName(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK), this.context.getWork().getOutputs());
        LineageInfo.DataContainer dc = new LineageInfo.DataContainer(tbl.getTTable());
        this.context.getQueryState().getLineageState().setLineage(new Path(((CreateMaterializedViewDesc)this.desc).getViewName()), dc, tbl.getCols());
        return 0;
    }
}

