/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.create;

import java.util.ArrayList;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.view.create.AbstractCreateViewAnalyzer;
import org.apache.hadoop.hive.ql.ddl.view.create.AlterViewAsDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={824})
public class AlterViewAsAnalyzer
extends AbstractCreateViewAnalyzer {
    public AlterViewAsAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        TableName viewName = AlterViewAsAnalyzer.getQualifiedTableName((ASTNode)root.getChild(0));
        String fqViewName = viewName.getNotEmptyDbTable();
        this.LOG.info("Altering the query of view " + fqViewName + " position=" + root.getCharPositionInLine());
        ASTNode select = (ASTNode)root.getChild(1).getChild(0);
        String originalText = this.ctx.getTokenRewriteStream().toString(select.getTokenStartIndex(), select.getTokenStopIndex());
        SemanticAnalyzer analyzer = this.analyzeQuery(select, fqViewName);
        this.schema = new ArrayList<FieldSchema>(analyzer.getResultSchema());
        ParseUtils.validateColumnNameUniqueness(analyzer.getOriginalResultSchema() == null ? this.schema : analyzer.getOriginalResultSchema());
        String expandedText = this.ctx.getTokenRewriteStream().toString(select.getTokenStartIndex(), select.getTokenStopIndex());
        AlterViewAsDesc desc = new AlterViewAsDesc(fqViewName, this.schema, originalText, expandedText);
        this.validateCreateView(desc, analyzer);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        DDLUtils.addDbAndTableToOutputs(this.getDatabase(viewName.getDb()), viewName, TableType.VIRTUAL_VIEW, false, null, this.outputs);
    }

    private void validateCreateView(AlterViewAsDesc desc, SemanticAnalyzer analyzer) throws SemanticException {
        this.validateTablesUsed(analyzer);
        Table oldView = null;
        try {
            oldView = this.getTable(desc.getViewName(), false);
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage(), (Throwable)e);
        }
        if (oldView == null) {
            String viewNotExistErrorMsg = "The following view does not exist: " + desc.getViewName();
            throw new SemanticException(ErrorMsg.ALTER_VIEW_AS_SELECT_NOT_EXIST.getMsg(viewNotExistErrorMsg));
        }
        this.validateReplaceWithPartitions(desc.getViewName(), oldView, null);
    }
}

