/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.create;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

abstract class AbstractCreateViewAnalyzer
extends BaseSemanticAnalyzer {
    protected List<FieldSchema> schema;

    AbstractCreateViewAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public List<FieldSchema> getResultSchema() {
        return this.schema;
    }

    protected SemanticAnalyzer analyzeQuery(ASTNode select, String fqViewName) throws SemanticException {
        QueryState innerQueryState = new QueryState.Builder().withHiveConf(this.conf).build();
        innerQueryState.getConf().setBoolVar(HiveConf.ConfVars.HIVE_RESULTSET_USE_UNIQUE_COLUMN_NAMES, false);
        SemanticAnalyzer analyzer = (SemanticAnalyzer)SemanticAnalyzerFactory.get(innerQueryState, select);
        this.ctx.setEnableUnparse(true);
        analyzer.forViewCreation(fqViewName);
        analyzer.analyze(select, this.ctx);
        analyzer.executeUnparseTranlations();
        this.queryState.setLineageState(innerQueryState.getLineageState());
        this.queryState.getLineageState().mapDirToOp(new Path(fqViewName), analyzer.getSinkOp());
        this.addInputs(analyzer);
        return analyzer;
    }

    private void addInputs(SemanticAnalyzer analyzer) {
        this.inputs.addAll(analyzer.getInputs());
        for (Map.Entry<String, TableScanOperator> entry : analyzer.getTopOps().entrySet()) {
            String alias = entry.getKey();
            TableScanOperator topOp = entry.getValue();
            ReadEntity parentViewInfo = PlanUtils.getParentViewInfo(alias, analyzer.getViewAliasToInput());
            Table table = ((TableScanDesc)topOp.getConf()).getTableMetadata();
            PlanUtils.addInput(this.inputs, new ReadEntity(table, parentViewInfo));
        }
    }

    protected void validateTablesUsed(SemanticAnalyzer analyzer) throws SemanticException {
        Set<String> tableAliases = analyzer.getQB().getTabAliases();
        for (String alias : tableAliases) {
            if ("_dummy_table".equals(alias)) continue;
            Table table = null;
            try {
                table = analyzer.getTableObjectByName(analyzer.getQB().getTabNameForAlias(alias));
            }
            catch (HiveException ex) {
                throw new SemanticException((Throwable)ex);
            }
            if (table.isTemporary()) {
                throw new SemanticException("View definition references temporary table " + alias);
            }
            if (!table.isMaterializedView()) continue;
            throw new SemanticException("View definition references materialized view " + alias);
        }
    }

    protected void validateReplaceWithPartitions(String viewName, Table oldView, List<FieldSchema> partitionColumns) throws SemanticException {
        if (oldView.getPartCols().isEmpty() || oldView.getPartCols().equals(partitionColumns)) {
            return;
        }
        String partitionViewErrorMsg = "The following view has partition, it could not be replaced: " + viewName;
        List<Partition> partitions = null;
        try {
            partitions = this.db.getPartitions(oldView);
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.REPLACE_VIEW_WITH_PARTITION.getMsg(partitionViewErrorMsg));
        }
        if (!partitions.isEmpty()) {
            throw new SemanticException(ErrorMsg.REPLACE_VIEW_WITH_PARTITION.getMsg(partitionViewErrorMsg));
        }
    }
}

