/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.skewed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public final class SkewedTableUtils {
    private SkewedTableUtils() {
        throw new UnsupportedOperationException("SkewedTableUtils should not be instantiated!");
    }

    public static List<String> analyzeSkewedTableDDLColNames(ASTNode node) throws SemanticException {
        ASTNode child = (ASTNode)node.getChild(0);
        if (child == null) {
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_NAME.getMsg());
        }
        if (child.getToken().getType() != 1137) {
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_NAME.getMsg());
        }
        return BaseSemanticAnalyzer.getColumnNames(child);
    }

    public static List<List<String>> analyzeDDLSkewedValues(ASTNode node) throws SemanticException {
        ASTNode child = (ASTNode)node.getChild(1);
        if (child == null) {
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_VALUE.getMsg());
        }
        ArrayList<List<String>> skewedValues = new ArrayList<List<String>>();
        switch (child.getToken().getType()) {
            case 1138: {
                for (String skewedValue : SkewedTableUtils.getSkewedValueFromASTNode(child)) {
                    skewedValues.add(Arrays.asList(skewedValue));
                }
                break;
            }
            case 1140: {
                for (Node cvNode : child.getChildren()) {
                    ASTNode acvNode = (ASTNode)cvNode;
                    if (acvNode.getToken().getType() != 1139) {
                        throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_VALUE.getMsg());
                    }
                    skewedValues.add(SkewedTableUtils.getSkewedValuesFromASTNode(acvNode));
                }
                break;
            }
        }
        return skewedValues;
    }

    public static List<String> getSkewedValuesFromASTNode(ASTNode node) throws SemanticException {
        ASTNode child = (ASTNode)node.getChild(0);
        if (child == null) {
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_VALUE.getMsg());
        }
        if (child.getToken().getType() != 1138) {
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_VALUE.getMsg());
        }
        return new ArrayList<String>(SkewedTableUtils.getSkewedValueFromASTNode(child));
    }

    private static List<String> getSkewedValueFromASTNode(ASTNode node) {
        ArrayList<String> colList = new ArrayList<String>();
        int numCh = node.getChildCount();
        for (int i = 0; i < numCh; ++i) {
            ASTNode child = (ASTNode)node.getChild(i);
            colList.add(BaseSemanticAnalyzer.stripQuotes(child.getText()).toLowerCase());
        }
        return colList;
    }
}

