/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.skewed;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.storage.skewed.AlterTableNotSkewedDesc;
import org.apache.hadoop.hive.ql.ddl.table.storage.skewed.AlterTableSkewedByDesc;
import org.apache.hadoop.hive.ql.ddl.table.storage.skewed.SkewedTableUtils;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ValidationUtility;

@DDLSemanticAnalyzerFactory.DDLType(types={814})
public class AlterTableSkewedByAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableSkewedByAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        Table table = this.getTable(tableName);
        this.validateAlterTableType(table, AlterTableType.SKEWED_BY, false);
        this.inputs.add(new ReadEntity(table));
        this.outputs.add(new WriteEntity(table, WriteEntity.WriteType.DDL_EXCLUSIVE));
        DDLDesc desc = null;
        if (command.getChildCount() == 0) {
            desc = new AlterTableNotSkewedDesc(tableName);
        } else {
            switch (((ASTNode)command.getChild(0)).getToken().getType()) {
                case 1157: {
                    desc = this.handleAlterTableSkewedBy(command, tableName, table);
                    break;
                }
                case 1122: {
                    desc = this.handleAlterTableDisableStoredAsDirs(tableName, table);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private DDLDesc handleAlterTableSkewedBy(ASTNode ast, TableName tableName, Table table) throws SemanticException {
        ASTNode skewedNode = (ASTNode)ast.getChild(0);
        List<String> skewedColumnNames = SkewedTableUtils.analyzeSkewedTableDDLColNames(skewedNode);
        List<List<String>> skewedColumnValues = SkewedTableUtils.analyzeDDLSkewedValues(skewedNode);
        boolean storedAsDirs = this.analyzeStoredAdDirs(skewedNode);
        if (table != null) {
            ValidationUtility.validateSkewedInformation(ParseUtils.validateColumnNameUniqueness(table.getCols()), skewedColumnNames, skewedColumnValues);
        }
        return new AlterTableSkewedByDesc(tableName, skewedColumnNames, skewedColumnValues, storedAsDirs);
    }

    private DDLDesc handleAlterTableDisableStoredAsDirs(TableName tableName, Table table) throws SemanticException {
        List<String> skewedColumnNames = table.getSkewedColNames();
        List<List<String>> skewedColumnValues = table.getSkewedColValues();
        if (CollectionUtils.isEmpty(skewedColumnNames) || CollectionUtils.isEmpty(skewedColumnValues)) {
            throw new SemanticException(ErrorMsg.ALTER_TBL_STOREDASDIR_NOT_SKEWED.getMsg(tableName.getNotEmptyDbTable()));
        }
        return new AlterTableSkewedByDesc(tableName, skewedColumnNames, skewedColumnValues, false);
    }
}

