/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.serde;

import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableOperation;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableUtils;
import org.apache.hadoop.hive.ql.ddl.table.storage.serde.AlterTableSetSerdeDesc;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.Deserializer;

public class AlterTableSetSerdeOperation
extends AbstractAlterTableOperation<AlterTableSetSerdeDesc> {
    public AlterTableSetSerdeOperation(DDLOperationContext context, AlterTableSetSerdeDesc desc) {
        super(context, desc);
    }

    @Override
    protected void doAlteration(Table table, Partition partition) throws HiveException {
        StorageDescriptor sd = this.getStorageDescriptor(table, partition);
        String serdeName = ((AlterTableSetSerdeDesc)this.desc).getSerdeName();
        String oldSerdeName = sd.getSerdeInfo().getSerializationLib();
        if (AlterTableUtils.isSchemaEvolutionEnabled(table, (Configuration)this.context.getConf()) && oldSerdeName.equalsIgnoreCase(OrcSerde.class.getName()) && !serdeName.equalsIgnoreCase(OrcSerde.class.getName())) {
            throw new HiveException(ErrorMsg.CANNOT_CHANGE_SERDE, new String[]{OrcSerde.class.getSimpleName(), ((AlterTableSetSerdeDesc)this.desc).getDbTableName()});
        }
        sd.getSerdeInfo().setSerializationLib(serdeName);
        if (MapUtils.isNotEmpty(((AlterTableSetSerdeDesc)this.desc).getProps())) {
            sd.getSerdeInfo().getParameters().putAll(((AlterTableSetSerdeDesc)this.desc).getProps());
        }
        if (partition == null && Table.shouldStoreFieldsInMetastore(this.context.getConf(), serdeName, table.getParameters()) && !Table.hasMetastoreBasedSchema(this.context.getConf(), oldSerdeName)) {
            try {
                Deserializer oldSerde = HiveMetaStoreUtils.getDeserializer((Configuration)this.context.getConf(), (org.apache.hadoop.hive.metastore.api.Table)table.getTTable(), (boolean)false, (String)oldSerdeName);
                table.setFields(Hive.getFieldsFromDeserializer(table.getTableName(), oldSerde));
            }
            catch (MetaException ex) {
                throw new HiveException((Throwable)ex);
            }
        }
    }
}

