/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.compact;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.storage.compact.AlterTableCompactDesc;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class AlterTableCompactOperation
extends DDLOperation<AlterTableCompactDesc> {
    public AlterTableCompactOperation(DDLOperationContext context, AlterTableCompactDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table table = this.context.getDb().getTable(((AlterTableCompactDesc)this.desc).getTableName());
        if (!AcidUtils.isTransactionalTable(table)) {
            throw new HiveException(ErrorMsg.NONACID_COMPACTION_NOT_SUPPORTED, new String[]{table.getDbName(), table.getTableName()});
        }
        String partitionName = this.getPartitionName(table);
        CompactionResponse resp = this.compact(table, partitionName);
        if (((AlterTableCompactDesc)this.desc).isBlocking() && resp.isAccepted()) {
            this.waitForCompactionToFinish(resp);
        }
        return 0;
    }

    private String getPartitionName(Table table) throws HiveException {
        String partitionName = null;
        if (((AlterTableCompactDesc)this.desc).getPartitionSpec() == null) {
            if (table.isPartitioned()) {
                throw new HiveException(ErrorMsg.NO_COMPACTION_PARTITION);
            }
        } else {
            Map<String, String> partitionSpec = ((AlterTableCompactDesc)this.desc).getPartitionSpec();
            List<Partition> partitions = this.context.getDb().getPartitions(table, partitionSpec);
            if (partitions.size() > 1) {
                throw new HiveException(ErrorMsg.TOO_MANY_COMPACTION_PARTITIONS);
            }
            if (partitions.size() == 0) {
                throw new HiveException(ErrorMsg.INVALID_PARTITION_SPEC);
            }
            partitionName = partitions.get(0).getName();
        }
        return partitionName;
    }

    private CompactionResponse compact(Table table, String partitionName) throws HiveException {
        CompactionResponse resp = this.context.getDb().compact2(table.getDbName(), table.getTableName(), partitionName, ((AlterTableCompactDesc)this.desc).getCompactionType(), ((AlterTableCompactDesc)this.desc).getProperties());
        if (resp.isAccepted()) {
            this.context.getConsole().printInfo("Compaction enqueued with id " + resp.getId());
        } else {
            this.context.getConsole().printInfo("Compaction already enqueued with id " + resp.getId() + "; State is " + resp.getState());
        }
        return resp;
    }

    private void waitForCompactionToFinish(CompactionResponse resp) throws HiveException {
        block11: {
            ShowCompactResponseElement compaction;
            StringBuilder progressDots = new StringBuilder();
            long waitTimeMs = 1000L;
            long waitTimeOut = HiveConf.getLongVar((Configuration)this.context.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_WAIT_TIMEOUT);
            block9: while (true) {
                waitTimeMs *= 2L;
                waitTimeMs = Math.min(waitTimeMs, waitTimeOut);
                try {
                    Thread.sleep(waitTimeMs);
                }
                catch (InterruptedException ex) {
                    this.context.getConsole().printInfo("Interrupted while waiting for compaction with id=" + resp.getId());
                    break block11;
                }
                ShowCompactResponse allCompactions = this.context.getDb().showCompactions();
                Iterator iterator = allCompactions.getCompacts().iterator();
                do {
                    if (!iterator.hasNext()) continue block9;
                    compaction = (ShowCompactResponseElement)iterator.next();
                } while (resp.getId() != compaction.getId());
                switch (compaction.getState()) {
                    case "working": 
                    case "initiated": {
                        this.context.getConsole().printInfo(progressDots.toString());
                        progressDots.append(".");
                        continue block9;
                    }
                }
                break;
            }
            this.context.getConsole().printInfo("Compaction with id " + resp.getId() + " finished with status: " + compaction.getState());
        }
    }
}

