/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.compact;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.storage.compact.AlterTableCompactDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={797})
public class AlterTableCompactAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableCompactAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        String type = AlterTableCompactAnalyzer.unescapeSQLString(command.getChild(0).getText()).toLowerCase();
        try {
            CompactionType.valueOf((String)type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new SemanticException(ErrorMsg.INVALID_COMPACTION_TYPE.getMsg());
        }
        Map<String, String> mapProp = null;
        boolean isBlocking = false;
        block6: for (int i = 0; i < command.getChildCount(); ++i) {
            switch (command.getChild(i).getType()) {
                case 1147: {
                    mapProp = AlterTableCompactAnalyzer.getProps((ASTNode)command.getChild(i).getChild(0));
                    continue block6;
                }
                case 849: {
                    isBlocking = true;
                    continue block6;
                }
            }
        }
        AlterTableCompactDesc desc = new AlterTableCompactDesc(tableName, partitionSpec, type, isBlocking, mapProp);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

