/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.drop;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.llap.LlapHiveUtils;
import org.apache.hadoop.hive.llap.ProactiveEviction;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.partition.drop.AlterTableDropPartitionDesc;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;

public class AlterTableDropPartitionOperation
extends DDLOperation<AlterTableDropPartitionDesc> {
    public AlterTableDropPartitionOperation(DDLOperationContext context, AlterTableDropPartitionDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table table = null;
        try {
            table = this.context.getDb().getTable(((AlterTableDropPartitionDesc)this.desc).getTableName());
        }
        catch (InvalidTableException invalidTableException) {
            // empty catch block
        }
        ReplicationSpec replicationSpec = ((AlterTableDropPartitionDesc)this.desc).getReplicationSpec();
        if (replicationSpec.isInReplicationScope()) {
            this.dropPartitionForReplication(table, replicationSpec);
        } else {
            this.dropPartitions();
        }
        return 0;
    }

    private void dropPartitionForReplication(Table table, ReplicationSpec replicationSpec) throws HiveException {
        if (table == null) {
            return;
        }
        for (AlterTableDropPartitionDesc.PartitionDesc partSpec : ((AlterTableDropPartitionDesc)this.desc).getPartSpecs()) {
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            try {
                this.context.getDb().getPartitionsByExpr(table, partSpec.getPartSpec(), this.context.getConf(), partitions);
                for (Partition p : Iterables.filter(partitions, replicationSpec.allowEventReplacementInto())) {
                    this.context.getDb().dropPartition(table.getDbName(), table.getTableName(), p.getValues(), true);
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
            }
            catch (Exception e) {
                throw new HiveException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void dropPartitions() throws HiveException {
        TableName tablenName = HiveTableName.of(((AlterTableDropPartitionDesc)this.desc).getTableName());
        ArrayList<Pair<Integer, byte[]>> partitionExpressions = new ArrayList<Pair<Integer, byte[]>>(((AlterTableDropPartitionDesc)this.desc).getPartSpecs().size());
        for (AlterTableDropPartitionDesc.PartitionDesc partSpec : ((AlterTableDropPartitionDesc)this.desc).getPartSpecs()) {
            partitionExpressions.add(Pair.of((Object)partSpec.getPrefixLength(), (Object)SerializationUtilities.serializeExpressionToKryo(partSpec.getPartSpec())));
        }
        PartitionDropOptions options = PartitionDropOptions.instance().deleteData(true).ifExists(true).purgeData(((AlterTableDropPartitionDesc)this.desc).getIfPurge());
        List<Partition> droppedPartitions = this.context.getDb().dropPartitions(tablenName.getDb(), tablenName.getTable(), partitionExpressions, options);
        ProactiveEviction.Request.Builder llapEvictRequestBuilder = LlapHiveUtils.isLlapMode((Configuration)this.context.getConf()) ? ProactiveEviction.Request.Builder.create() : null;
        for (Partition partition : droppedPartitions) {
            this.context.getConsole().printInfo("Dropped the partition " + partition.getName());
            DDLUtils.addIfAbsentByName(new WriteEntity(partition, WriteEntity.WriteType.DDL_NO_LOCK), this.context);
            if (llapEvictRequestBuilder == null) continue;
            llapEvictRequestBuilder.addPartitionOfATable(tablenName.getDb(), tablenName.getTable(), partition.getSpec());
        }
        if (llapEvictRequestBuilder != null) {
            ProactiveEviction.evict((Configuration)this.context.getConf(), llapEvictRequestBuilder.build());
        }
    }
}

