/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.alter;

import java.util.ArrayList;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.partition.alter.AlterTableAlterPartitionDesc;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class AlterTableAlterPartitionOperation
extends DDLOperation<AlterTableAlterPartitionDesc> {
    public AlterTableAlterPartitionOperation(DDLOperationContext context, AlterTableAlterPartitionDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table tbl = this.context.getDb().getTable(((AlterTableAlterPartitionDesc)this.desc).getTableName(), true);
        this.check(tbl);
        this.setNewPartitionKeys(tbl);
        this.alterTable(tbl);
        return 0;
    }

    private void check(Table tbl) throws HiveException {
        assert (tbl.isPartitioned());
        try {
            int colIndex = this.getColumnIndex(tbl);
            this.checkPartitionValues(tbl, colIndex);
        }
        catch (Exception e) {
            throw new HiveException("Exception while checking type conversion of existing partition values to " + ((AlterTableAlterPartitionDesc)this.desc).getPartKeySpec() + " : " + e.getMessage());
        }
    }

    private int getColumnIndex(Table tbl) throws HiveException {
        int colIndex = -1;
        for (FieldSchema col : tbl.getTTable().getPartitionKeys()) {
            ++colIndex;
            if (col.getName().compareTo(((AlterTableAlterPartitionDesc)this.desc).getPartKeyName()) != 0) continue;
            return colIndex;
        }
        throw new HiveException("Cannot find partition column " + ((AlterTableAlterPartitionDesc)this.desc).getPartKeyName());
    }

    private void checkPartitionValues(Table tbl, int colIndex) throws HiveException {
        TypeInfo expectedType = TypeInfoUtils.getTypeInfoFromTypeString((String)((AlterTableAlterPartitionDesc)this.desc).getPartKeyType());
        ObjectInspector outputOI = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)expectedType);
        ObjectInspectorConverters.Converter converter = ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)outputOI);
        Set<Partition> partitions = this.context.getDb().getAllPartitionsOf(tbl);
        for (Partition part : partitions) {
            if (part.getName().equals(this.context.getConf().getVar(HiveConf.ConfVars.DEFAULTPARTITIONNAME))) continue;
            try {
                String value = part.getValues().get(colIndex);
                Object convertedValue = converter.convert((Object)value);
                if (convertedValue != null) continue;
                throw new HiveException(" Converting from " + TypeInfoFactory.stringTypeInfo + " to " + expectedType + " for value : " + value + " resulted in NULL object");
            }
            catch (Exception e) {
                throw new HiveException("Exception while converting " + TypeInfoFactory.stringTypeInfo + " to " + expectedType + " for value : " + part.getValues().get(colIndex));
            }
        }
    }

    private void setNewPartitionKeys(Table tbl) {
        ArrayList<FieldSchema> newPartitionKeys = new ArrayList<FieldSchema>();
        for (FieldSchema col : tbl.getTTable().getPartitionKeys()) {
            if (col.getName().compareTo(((AlterTableAlterPartitionDesc)this.desc).getPartKeyName()) == 0) {
                newPartitionKeys.add(((AlterTableAlterPartitionDesc)this.desc).getPartKeySpec());
                continue;
            }
            newPartitionKeys.add(col);
        }
        tbl.getTTable().setPartitionKeys(newPartitionKeys);
    }

    private void alterTable(Table tbl) throws HiveException {
        this.context.getDb().alterTable(tbl, false, null, true);
        this.context.getWork().getInputs().add(new ReadEntity(tbl));
        DDLUtils.addIfAbsentByName(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK), this.context);
    }
}

