/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PartitionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionUtils.class);

    private PartitionUtils() {
        throw new UnsupportedOperationException("PartitionUtils should not be instantiated");
    }

    public static void validatePartitions(HiveConf conf, Map<String, String> partitionSpec) throws SemanticException {
        HashSet<String> reservedPartitionValues = new HashSet<String>();
        reservedPartitionValues.add(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.DEFAULTPARTITIONNAME));
        reservedPartitionValues.add(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.DEFAULT_ZOOKEEPER_PARTITION_NAME));
        reservedPartitionValues.add(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_INT_ORIGINAL));
        reservedPartitionValues.add(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_INT_ARCHIVED));
        reservedPartitionValues.add(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_INT_EXTRACTED));
        for (Map.Entry<String, String> e : partitionSpec.entrySet()) {
            for (String s : reservedPartitionValues) {
                String value = e.getValue();
                if (value == null || !value.contains(s)) continue;
                throw new SemanticException(ErrorMsg.RESERVED_PART_VAL.getMsg("(User value: " + e.getValue() + " Reserved substring: " + s + ")"));
            }
        }
    }

    public static ExprNodeGenericFuncDesc makeBinaryPredicate(String fn, ExprNodeDesc left, ExprNodeDesc right) throws SemanticException {
        return new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getFunctionInfo(fn).getGenericUDF(), (List<ExprNodeDesc>)Lists.newArrayList((Object[])new ExprNodeDesc[]{left, right}));
    }

    public static ExprNodeGenericFuncDesc makeUnaryPredicate(String fn, ExprNodeDesc arg) throws SemanticException {
        return new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getFunctionInfo(fn).getGenericUDF(), (List<ExprNodeDesc>)Lists.newArrayList((Object[])new ExprNodeDesc[]{arg}));
    }

    public static Partition getPartition(Hive db, Table table, Map<String, String> partitionSpec, boolean throwException) throws SemanticException {
        Partition partition;
        try {
            partition = db.getPartition(table, partitionSpec, false);
        }
        catch (Exception e) {
            throw new SemanticException(PartitionUtils.toMessage(ErrorMsg.INVALID_PARTITION, partitionSpec), (Throwable)e);
        }
        if (partition == null && throwException) {
            throw new SemanticException(PartitionUtils.toMessage(ErrorMsg.INVALID_PARTITION, partitionSpec));
        }
        return partition;
    }

    public static List<Partition> getPartitions(Hive db, Table table, Map<String, String> partitionSpec, boolean throwException) throws SemanticException {
        List<Partition> partitions;
        try {
            partitions = partitionSpec == null ? db.getPartitions(table) : db.getPartitions(table, partitionSpec);
        }
        catch (Exception e) {
            throw new SemanticException(PartitionUtils.toMessage(ErrorMsg.INVALID_PARTITION, partitionSpec), (Throwable)e);
        }
        if (partitions.isEmpty() && throwException) {
            throw new SemanticException(PartitionUtils.toMessage(ErrorMsg.INVALID_PARTITION, partitionSpec));
        }
        return partitions;
    }

    private static String toMessage(ErrorMsg message, Object detail) {
        return detail == null ? message.getMsg() : message.getMsg(detail.toString());
    }

    public static void addTablePartsOutputs(Hive db, Set<WriteEntity> outputs, Table table, List<Map<String, String>> partitionSpecs, boolean allowMany, WriteEntity.WriteType writeType) throws SemanticException {
        for (Map<String, String> partitionSpec : partitionSpecs) {
            List<Object> parts = null;
            if (allowMany) {
                try {
                    parts = db.getPartitions(table, partitionSpec);
                }
                catch (HiveException e) {
                    LOG.error("Got HiveException during obtaining list of partitions", (Throwable)e);
                    throw new SemanticException(e.getMessage(), (Throwable)e);
                }
            }
            parts = new ArrayList();
            try {
                Partition p = db.getPartition(table, partitionSpec, false);
                if (p != null) {
                    parts.add(p);
                }
            }
            catch (HiveException e) {
                LOG.debug("Wrong specification", (Throwable)e);
                throw new SemanticException(e.getMessage(), (Throwable)e);
            }
            for (Partition partition : parts) {
                outputs.add(new WriteEntity(partition, writeType));
            }
        }
    }
}

