/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.show.tables;

import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.table.info.show.tables.ShowTablesDesc;
import org.apache.hadoop.hive.ql.ddl.table.info.show.tables.ShowTablesFormatter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.udf.UDFLike;

public class ShowTablesOperation
extends DDLOperation<ShowTablesDesc> {
    public ShowTablesOperation(DDLOperationContext context, ShowTablesDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        if (!this.context.getDb().databaseExists(((ShowTablesDesc)this.desc).getDbName())) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, new String[]{((ShowTablesDesc)this.desc).getDbName()});
        }
        if (!((ShowTablesDesc)this.desc).isExtended()) {
            this.showTables();
        } else {
            this.showTablesExtended();
        }
        return 0;
    }

    private void showTables() throws HiveException {
        List<String> tableNames = new ArrayList<String>(this.context.getDb().getTablesByType(((ShowTablesDesc)this.desc).getDbName(), null, ((ShowTablesDesc)this.desc).getTypeFilter()));
        if (((ShowTablesDesc)this.desc).getPattern() != null) {
            Pattern pattern = Pattern.compile(UDFLike.likePatternToRegExp(((ShowTablesDesc)this.desc).getPattern()), 2);
            tableNames = tableNames.stream().filter(name -> pattern.matcher((CharSequence)name).matches()).collect(Collectors.toList());
        }
        Collections.sort(tableNames);
        LOG.debug("Found {} table(s) matching the SHOW TABLES statement.", (Object)tableNames.size());
        try (DataOutputStream os = ShowUtils.getOutputStream(new Path(((ShowTablesDesc)this.desc).getResFile()), this.context);){
            ShowTablesFormatter formatter = ShowTablesFormatter.getFormatter(this.context.getConf());
            formatter.showTables(os, tableNames);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, new String[]{"in database " + ((ShowTablesDesc)this.desc).getDbName()});
        }
    }

    private void showTablesExtended() throws HiveException {
        ArrayList<Table> tableObjects = new ArrayList<Table>();
        tableObjects.addAll(this.context.getDb().getTableObjects(((ShowTablesDesc)this.desc).getDbName(), null, ((ShowTablesDesc)this.desc).getTypeFilter()));
        if (((ShowTablesDesc)this.desc).getPattern() != null) {
            Pattern pattern = Pattern.compile(UDFLike.likePatternToRegExp(((ShowTablesDesc)this.desc).getPattern()), 2);
            tableObjects = tableObjects.stream().filter(object -> pattern.matcher(object.getTableName()).matches()).collect(Collectors.toList());
        }
        Collections.sort(tableObjects, Comparator.comparing(Table::getTableName));
        LOG.debug("Found {} table(s) matching the SHOW EXTENDED TABLES statement.", (Object)tableObjects.size());
        try (DataOutputStream os = ShowUtils.getOutputStream(new Path(((ShowTablesDesc)this.desc).getResFile()), this.context);){
            ShowTablesFormatter formatter = ShowTablesFormatter.getFormatter(this.context.getConf());
            formatter.showTablesExtended(os, tableObjects);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, new String[]{"in database " + ((ShowTablesDesc)this.desc).getDbName()});
        }
    }
}

