/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.show.tables;

import com.google.common.collect.ImmutableMap;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.MapBuilder;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.session.SessionState;

public abstract class ShowTablesFormatter {
    public static ShowTablesFormatter getFormatter(HiveConf conf) {
        if (MetaDataFormatUtils.isJson(conf)) {
            return new JsonShowTablesFormatter();
        }
        return new TextShowTablesFormatter();
    }

    public abstract void showTables(DataOutputStream var1, List<String> var2) throws HiveException;

    abstract void showTablesExtended(DataOutputStream var1, List<Table> var2) throws HiveException;

    static class TextShowTablesFormatter
    extends ShowTablesFormatter {
        TextShowTablesFormatter() {
        }

        @Override
        public void showTables(DataOutputStream out, List<String> tables) throws HiveException {
            Iterator<String> iterTbls = tables.iterator();
            try {
                while (iterTbls.hasNext()) {
                    out.write(iterTbls.next().getBytes(StandardCharsets.UTF_8));
                    out.write(10);
                }
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
        }

        @Override
        void showTablesExtended(DataOutputStream out, List<Table> tables) throws HiveException {
            if (tables.isEmpty()) {
                return;
            }
            try {
                ShowUtils.TextMetaDataTable mdt = new ShowUtils.TextMetaDataTable();
                if (!SessionState.get().isHiveServerQuery()) {
                    mdt.addRow("# Table Name", "Table Type");
                }
                for (Table table : tables) {
                    mdt.addRow(table.getTableName(), table.getTableType().toString());
                }
                out.write(mdt.renderTable(!SessionState.get().isHiveServerQuery()).getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
        }
    }

    static class JsonShowTablesFormatter
    extends ShowTablesFormatter {
        JsonShowTablesFormatter() {
        }

        @Override
        public void showTables(DataOutputStream out, List<String> tables) throws HiveException {
            ShowUtils.asJson(out, MapBuilder.create().put("tables", tables).build());
        }

        @Override
        void showTablesExtended(DataOutputStream out, List<Table> tables) throws HiveException {
            if (tables.isEmpty()) {
                return;
            }
            ArrayList<ImmutableMap> tableDataList = new ArrayList<ImmutableMap>();
            for (Table table : tables) {
                ImmutableMap tableData = ImmutableMap.of((Object)"Table Name", (Object)table.getTableName(), (Object)"Table Type", (Object)table.getTableType().toString());
                tableDataList.add(tableData);
            }
            ShowUtils.asJson(out, (Map<String, Object>)ImmutableMap.of((Object)"tables", tableDataList));
        }
    }
}

