/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.show.properties;

import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.info.show.properties.ShowTablePropertiesDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1113})
public class ShowTablePropertiesAnalyzer
extends BaseSemanticAnalyzer {
    public ShowTablePropertiesAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        TableName tableName = ShowTablePropertiesAnalyzer.getQualifiedTableName((ASTNode)root.getChild(0));
        String propertyName = root.getChildCount() > 1 ? ShowTablePropertiesAnalyzer.unescapeSQLString(root.getChild(1).getText()) : null;
        this.getTable(tableName);
        ShowTablePropertiesDesc desc = new ShowTablePropertiesDesc(this.ctx.getResFile().toString(), tableName, propertyName);
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask("prpt_name,prpt_value#string:string"));
    }
}

