/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.desc;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.info.desc.DescTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={894})
public class DescTableAnalyzer
extends BaseSemanticAnalyzer {
    public DescTableAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        ASTNode tableTypeExpr = (ASTNode)root.getChild(0);
        TableName tableName = DescTableAnalyzer.getQualifiedTableName((ASTNode)tableTypeExpr.getChild(0));
        if (tableName.getDb() != null) {
            this.db.validateDatabaseExists(tableName.getDb());
        }
        Table table = this.getTable(tableName);
        Map<String, String> partitionSpec = this.getPartitionSpec(this.db, tableTypeExpr, tableName);
        if (partitionSpec != null) {
            PartitionUtils.getPartition(this.db, table, partitionSpec, true);
        }
        String columnPath = this.getColumnPath(this.db, tableTypeExpr, tableName, partitionSpec);
        boolean showColStats = false;
        boolean isFormatted = false;
        boolean isExt = false;
        if (root.getChildCount() == 2) {
            int descOptions = root.getChild(1).getType();
            isFormatted = descOptions == 149;
            boolean bl = isExt = descOptions == 133;
            if (columnPath != null && isFormatted) {
                showColStats = true;
            }
        }
        this.inputs.add(new ReadEntity(table));
        DescTableDesc desc = new DescTableDesc(this.ctx.getResFile(), tableName, partitionSpec, columnPath, isExt, isFormatted);
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        String schema = showColStats ? "column_property,value#string:string" : "col_name,data_type,comment#string:string:string";
        this.setFetchTask(this.createFetchTask(schema));
    }

    private String getColumnPath(Hive db, ASTNode node, TableName tableName, Map<String, String> partitionSpec) throws SemanticException {
        if (node.getChildCount() == 1) {
            return null;
        }
        if (node.getChildCount() > 1) {
            ASTNode columnNode;
            ASTNode aSTNode = columnNode = partitionSpec == null ? (ASTNode)node.getChild(1) : (ASTNode)node.getChild(2);
            if (columnNode != null) {
                return String.join((CharSequence)".", tableName.getNotEmptyDbTable(), DDLUtils.getFQName(columnNode));
            }
        }
        return null;
    }

    private Map<String, String> getPartitionSpec(Hive db, ASTNode node, TableName tableName) throws SemanticException {
        if (node.getChildCount() == 1) {
            return null;
        }
        if (node.getChildCount() > 2 && ((ASTNode)node.getChild(1)).getType() != 1027) {
            throw new SemanticException(((ASTNode)node.getChild(1)).getType() + " is not a partition specification");
        }
        if (((ASTNode)node.getChild(1)).getType() == 1027) {
            ASTNode partNode = (ASTNode)node.getChild(1);
            Table tab = null;
            try {
                tab = db.getTable(tableName.getNotEmptyDbTable());
            }
            catch (InvalidTableException e) {
                throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName.getNotEmptyDbTable()), (Throwable)((Object)e));
            }
            catch (HiveException e) {
                throw new SemanticException(e.getMessage(), (Throwable)e);
            }
            Map<String, String> partitionSpec = null;
            try {
                partitionSpec = DescTableAnalyzer.getValidatedPartSpec(tab, partNode, db.getConf(), false);
            }
            catch (SemanticException e) {
                return null;
            }
            if (partitionSpec != null) {
                Partition part = null;
                try {
                    part = db.getPartition(tab, partitionSpec, false);
                }
                catch (HiveException e) {
                    return null;
                }
                if (part == null) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(partitionSpec.toString()));
                }
                return partitionSpec;
            }
        }
        return null;
    }
}

