/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.create;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableOperation;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ValidationUtility;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.mapred.OutputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Explain(displayName="Create Table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateTableDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CreateTableDesc.class);
    TableName tableName;
    boolean isExternal;
    List<FieldSchema> cols;
    List<FieldSchema> partCols;
    List<String> partColNames;
    List<String> bucketCols;
    List<Order> sortCols;
    int numBuckets;
    String fieldDelim;
    String fieldEscape;
    String collItemDelim;
    String mapKeyDelim;
    String lineDelim;
    String nullFormat;
    String comment;
    String inputFormat;
    String outputFormat;
    String location;
    String serName;
    String storageHandler;
    Map<String, String> serdeProps;
    Map<String, String> tblProps;
    boolean ifNotExists;
    List<String> skewedColNames;
    List<List<String>> skewedColValues;
    boolean isStoredAsSubDirectories = false;
    boolean isTemporary = false;
    private boolean isMaterialization = false;
    private boolean replaceMode = false;
    private ReplicationSpec replicationSpec = null;
    private boolean isCTAS = false;
    List<SQLPrimaryKey> primaryKeys;
    List<SQLForeignKey> foreignKeys;
    List<SQLUniqueConstraint> uniqueConstraints;
    List<SQLNotNullConstraint> notNullConstraints;
    List<SQLDefaultConstraint> defaultConstraints;
    List<SQLCheckConstraint> checkConstraints;
    private ColumnStatistics colStats;
    private Long initialMmWriteId;
    private transient FileSinkDesc writer;
    private Long replWriteId;
    private String ownerName = null;

    public CreateTableDesc() {
    }

    public CreateTableDesc(TableName tableName, boolean isExternal, boolean isTemporary, List<FieldSchema> cols, List<FieldSchema> partCols, List<String> bucketCols, List<Order> sortCols, int numBuckets, String fieldDelim, String fieldEscape, String collItemDelim, String mapKeyDelim, String lineDelim, String comment, String inputFormat, String outputFormat, String location, String serName, String storageHandler, Map<String, String> serdeProps, Map<String, String> tblProps, boolean ifNotExists, List<String> skewedColNames, List<List<String>> skewedColValues, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints, ColumnStatistics colStats, long writeId) {
        this(tableName, isExternal, isTemporary, cols, partCols, bucketCols, sortCols, numBuckets, fieldDelim, fieldEscape, collItemDelim, mapKeyDelim, lineDelim, comment, inputFormat, outputFormat, location, serName, storageHandler, serdeProps, tblProps, ifNotExists, skewedColNames, skewedColValues, primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraints, checkConstraints);
        this.colStats = colStats;
        this.replWriteId = writeId;
    }

    public CreateTableDesc(TableName tableName, boolean isExternal, boolean isTemporary, List<FieldSchema> cols, List<String> partColNames, List<String> bucketCols, List<Order> sortCols, int numBuckets, String fieldDelim, String fieldEscape, String collItemDelim, String mapKeyDelim, String lineDelim, String comment, String inputFormat, String outputFormat, String location, String serName, String storageHandler, Map<String, String> serdeProps, Map<String, String> tblProps, boolean ifNotExists, List<String> skewedColNames, List<List<String>> skewedColValues, boolean isCTAS, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) {
        this(tableName, isExternal, isTemporary, cols, new ArrayList<FieldSchema>(), bucketCols, sortCols, numBuckets, fieldDelim, fieldEscape, collItemDelim, mapKeyDelim, lineDelim, comment, inputFormat, outputFormat, location, serName, storageHandler, serdeProps, tblProps, ifNotExists, skewedColNames, skewedColValues, primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraints, checkConstraints, null, -1L);
        this.partColNames = partColNames;
        this.isCTAS = isCTAS;
    }

    public CreateTableDesc(TableName tableName, boolean isExternal, boolean isTemporary, List<FieldSchema> cols, List<FieldSchema> partCols, List<String> bucketCols, List<Order> sortCols, int numBuckets, String fieldDelim, String fieldEscape, String collItemDelim, String mapKeyDelim, String lineDelim, String comment, String inputFormat, String outputFormat, String location, String serName, String storageHandler, Map<String, String> serdeProps, Map<String, String> tblProps, boolean ifNotExists, List<String> skewedColNames, List<List<String>> skewedColValues, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) {
        this.tableName = tableName;
        this.isExternal = isExternal;
        this.isTemporary = isTemporary;
        this.bucketCols = new ArrayList<String>(bucketCols);
        this.sortCols = new ArrayList<Order>(sortCols);
        this.collItemDelim = collItemDelim;
        this.cols = new ArrayList<FieldSchema>(cols);
        this.comment = comment;
        this.fieldDelim = fieldDelim;
        this.fieldEscape = fieldEscape;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.lineDelim = lineDelim;
        this.location = location;
        this.mapKeyDelim = mapKeyDelim;
        this.numBuckets = numBuckets;
        this.partCols = new ArrayList<FieldSchema>(partCols);
        this.serName = serName;
        this.storageHandler = storageHandler;
        this.serdeProps = serdeProps;
        this.tblProps = tblProps;
        this.ifNotExists = ifNotExists;
        this.skewedColNames = CreateTableDesc.copyList(skewedColNames);
        this.skewedColValues = CreateTableDesc.copyList(skewedColValues);
        this.primaryKeys = CreateTableDesc.copyList(primaryKeys);
        this.foreignKeys = CreateTableDesc.copyList(foreignKeys);
        this.uniqueConstraints = CreateTableDesc.copyList(uniqueConstraints);
        this.notNullConstraints = CreateTableDesc.copyList(notNullConstraints);
        this.defaultConstraints = CreateTableDesc.copyList(defaultConstraints);
        this.checkConstraints = CreateTableDesc.copyList(checkConstraints);
    }

    private static <T> List<T> copyList(List<T> copy) {
        return copy == null ? null : new ArrayList<T>(copy);
    }

    @Explain(displayName="columns")
    public List<String> getColsString() {
        return Utilities.getFieldSchemaString(this.getCols());
    }

    @Explain(displayName="partition columns")
    public List<String> getPartColsString() {
        return Utilities.getFieldSchemaString(this.getPartCols());
    }

    @Explain(displayName="if not exists", displayOnlyOnTrue=true)
    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getDbTableName() {
        return this.tableName.getNotEmptyDbTable();
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.tableName.getDb();
    }

    public void setTableName(TableName tableName) {
        this.tableName = tableName;
    }

    public List<FieldSchema> getCols() {
        return this.cols;
    }

    public void setCols(ArrayList<FieldSchema> cols) {
        this.cols = cols;
    }

    public List<FieldSchema> getPartCols() {
        return this.partCols;
    }

    public void setPartCols(ArrayList<FieldSchema> partCols) {
        this.partCols = partCols;
    }

    public List<String> getPartColNames() {
        return this.partColNames;
    }

    public void setPartColNames(ArrayList<String> partColNames) {
        this.partColNames = partColNames;
    }

    public List<SQLPrimaryKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(ArrayList<SQLPrimaryKey> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public List<SQLForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(ArrayList<SQLForeignKey> foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    public List<SQLUniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public List<SQLNotNullConstraint> getNotNullConstraints() {
        return this.notNullConstraints;
    }

    public List<SQLDefaultConstraint> getDefaultConstraints() {
        return this.defaultConstraints;
    }

    public List<SQLCheckConstraint> getCheckConstraints() {
        return this.checkConstraints;
    }

    @Explain(displayName="bucket columns")
    public List<String> getBucketCols() {
        return this.bucketCols;
    }

    public void setBucketCols(ArrayList<String> bucketCols) {
        this.bucketCols = bucketCols;
    }

    @Explain(displayName="# buckets")
    public Integer getNumBucketsExplain() {
        if (this.numBuckets == -1) {
            return null;
        }
        return this.numBuckets;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(int numBuckets) {
        this.numBuckets = numBuckets;
    }

    @Explain(displayName="field delimiter")
    public String getFieldDelim() {
        return this.fieldDelim;
    }

    public void setFieldDelim(String fieldDelim) {
        this.fieldDelim = fieldDelim;
    }

    @Explain(displayName="field escape")
    public String getFieldEscape() {
        return this.fieldEscape;
    }

    public void setFieldEscape(String fieldEscape) {
        this.fieldEscape = fieldEscape;
    }

    @Explain(displayName="collection delimiter")
    public String getCollItemDelim() {
        return this.collItemDelim;
    }

    public void setCollItemDelim(String collItemDelim) {
        this.collItemDelim = collItemDelim;
    }

    @Explain(displayName="map key delimiter")
    public String getMapKeyDelim() {
        return this.mapKeyDelim;
    }

    public void setMapKeyDelim(String mapKeyDelim) {
        this.mapKeyDelim = mapKeyDelim;
    }

    @Explain(displayName="line delimiter")
    public String getLineDelim() {
        return this.lineDelim;
    }

    public void setLineDelim(String lineDelim) {
        this.lineDelim = lineDelim;
    }

    @Explain(displayName="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Explain(displayName="input format")
    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    @Explain(displayName="output format")
    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Explain(displayName="storage handler")
    public String getStorageHandler() {
        return this.storageHandler;
    }

    public void setStorageHandler(String storageHandler) {
        this.storageHandler = storageHandler;
    }

    @Explain(displayName="location")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Explain(displayName="isExternal", displayOnlyOnTrue=true)
    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    @Explain(displayName="sort columns")
    public List<Order> getSortCols() {
        return this.sortCols;
    }

    public void setSortCols(ArrayList<Order> sortCols) {
        this.sortCols = sortCols;
    }

    @Explain(displayName="serde name")
    public String getSerName() {
        return this.serName;
    }

    public void setSerName(String serName) {
        this.serName = serName;
    }

    @Explain(displayName="serde properties")
    public Map<String, String> getSerdeProps() {
        return this.serdeProps;
    }

    public void setSerdeProps(Map<String, String> serdeProps) {
        this.serdeProps = serdeProps;
    }

    public Map<String, String> getTblProps() {
        return this.tblProps;
    }

    @Explain(displayName="table properties")
    public Map<String, String> getTblPropsExplain() {
        HashMap<String, String> copy = new HashMap<String, String>(this.tblProps);
        copy.remove("created_with_ctas");
        return copy;
    }

    public void setTblProps(Map<String, String> tblProps) {
        this.tblProps = tblProps;
    }

    public List<String> getSkewedColNames() {
        return this.skewedColNames;
    }

    public void setSkewedColNames(ArrayList<String> skewedColNames) {
        this.skewedColNames = skewedColNames;
    }

    public List<List<String>> getSkewedColValues() {
        return this.skewedColValues;
    }

    public void setSkewedColValues(ArrayList<List<String>> skewedColValues) {
        this.skewedColValues = skewedColValues;
    }

    public void validate(HiveConf conf) throws SemanticException {
        boolean found;
        if (this.getCols() == null || this.getCols().size() == 0) {
            if (Table.hasMetastoreBasedSchema(conf, this.serName) && StringUtils.isEmpty((CharSequence)this.getStorageHandler())) {
                throw new SemanticException(ErrorMsg.INVALID_TBL_DDL_SERDE.getMsg());
            }
            return;
        }
        if (this.getStorageHandler() == null) {
            try {
                Class<?> origin = Class.forName(this.getOutputFormat(), true, Utilities.getSessionSpecifiedClassLoader());
                Class<? extends OutputFormat> replaced = HiveFileFormatUtils.getOutputFormatSubstitute(origin);
                if (!HiveOutputFormat.class.isAssignableFrom(replaced)) {
                    throw new SemanticException(ErrorMsg.INVALID_OUTPUT_FORMAT_TYPE.getMsg());
                }
            }
            catch (ClassNotFoundException e) {
                throw new SemanticException(ErrorMsg.CLASSPATH_ERROR.getMsg(), (Throwable)e);
            }
        }
        List<String> colNames = ParseUtils.validateColumnNameUniqueness(this.getCols());
        if (this.getBucketCols() != null) {
            for (String bucketCol : this.getBucketCols()) {
                found = false;
                for (String colName : colNames) {
                    if (!bucketCol.equalsIgnoreCase(colName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(" '" + bucketCol + "'"));
            }
        }
        if (this.getSortCols() != null) {
            Iterator<Order> sortCols = this.getSortCols().iterator();
            while (sortCols.hasNext()) {
                String sortCol = sortCols.next().getCol();
                found = false;
                for (String colName : colNames) {
                    if (!sortCol.equalsIgnoreCase(colName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(" '" + sortCol + "'"));
            }
        }
        if (this.getPartCols() != null) {
            for (FieldSchema fs : this.getPartCols()) {
                String partCol = fs.getName();
                PrimitiveTypeInfo pti = null;
                try {
                    pti = TypeInfoFactory.getPrimitiveTypeInfo((String)fs.getType());
                }
                catch (Exception err) {
                    LOG.error("Failed to get type info", (Throwable)err);
                }
                if (null == pti) {
                    throw new SemanticException(ErrorMsg.PARTITION_COLUMN_NON_PRIMITIVE.getMsg() + " Found " + partCol + " of type: " + fs.getType());
                }
                Iterator<String> colNamesIter = colNames.iterator();
                while (colNamesIter.hasNext()) {
                    String colName = BaseSemanticAnalyzer.unescapeIdentifier(colNamesIter.next());
                    if (!partCol.equalsIgnoreCase(colName)) continue;
                    throw new SemanticException(ErrorMsg.COLUMN_REPEATED_IN_PARTITIONING_COLS.getMsg());
                }
            }
        }
        ValidationUtility.validateSkewedInformation(colNames, this.getSkewedColNames(), this.getSkewedColValues());
    }

    public boolean isStoredAsSubDirectories() {
        return this.isStoredAsSubDirectories;
    }

    public void setStoredAsSubDirectories(boolean isStoredAsSubDirectories) {
        this.isStoredAsSubDirectories = isStoredAsSubDirectories;
    }

    public String getNullFormat() {
        return this.nullFormat;
    }

    public void setNullFormat(String nullFormat) {
        this.nullFormat = nullFormat;
    }

    @Explain(displayName="isTemporary", displayOnlyOnTrue=true)
    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void setTemporary(boolean isTemporary) {
        this.isTemporary = isTemporary;
    }

    @Explain(displayName="isMaterialization", displayOnlyOnTrue=true)
    public boolean isMaterialization() {
        return this.isMaterialization;
    }

    public void setMaterialization(boolean isMaterialization) {
        this.isMaterialization = isMaterialization;
    }

    public void setReplaceMode(boolean replaceMode) {
        this.replaceMode = replaceMode;
    }

    public boolean getReplaceMode() {
        return this.replaceMode;
    }

    public void setReplicationSpec(ReplicationSpec replicationSpec) {
        this.replicationSpec = replicationSpec;
    }

    public ReplicationSpec getReplicationSpec() {
        if (this.replicationSpec == null) {
            this.replicationSpec = new ReplicationSpec();
        }
        return this.replicationSpec;
    }

    public boolean isCTAS() {
        return this.isCTAS;
    }

    public Table toTable(HiveConf conf) throws HiveException {
        String serDeClassName;
        Table tbl = new Table(this.tableName.getDb(), this.tableName.getTable());
        if (this.getTblProps() != null) {
            tbl.getTTable().getParameters().putAll(this.getTblProps());
        }
        if (this.getPartCols() != null) {
            tbl.setPartCols(this.getPartCols());
        }
        if (this.getNumBuckets() != -1) {
            tbl.setNumBuckets(this.getNumBuckets());
        }
        if (this.getStorageHandler() != null) {
            tbl.setProperty("storage_handler", this.getStorageHandler());
        }
        HiveStorageHandler storageHandler = tbl.getStorageHandler();
        if (this.getSerName() == null) {
            if (storageHandler == null) {
                serDeClassName = PlanUtils.getDefaultSerDe().getName();
                LOG.info("Default to " + serDeClassName + " for table " + this.tableName);
            } else {
                serDeClassName = storageHandler.getSerDeClass().getName();
                LOG.info("Use StorageHandler-supplied " + serDeClassName + " for table " + this.tableName);
            }
        } else {
            serDeClassName = this.getSerName();
            DDLUtils.validateSerDe(serDeClassName, conf);
        }
        tbl.setSerializationLib(serDeClassName);
        if (this.getFieldDelim() != null) {
            tbl.setSerdeParam("field.delim", this.getFieldDelim());
            tbl.setSerdeParam("serialization.format", this.getFieldDelim());
        }
        if (this.getFieldEscape() != null) {
            tbl.setSerdeParam("escape.delim", this.getFieldEscape());
        }
        if (this.getCollItemDelim() != null) {
            tbl.setSerdeParam("collection.delim", this.getCollItemDelim());
        }
        if (this.getMapKeyDelim() != null) {
            tbl.setSerdeParam("mapkey.delim", this.getMapKeyDelim());
        }
        if (this.getLineDelim() != null) {
            tbl.setSerdeParam("line.delim", this.getLineDelim());
        }
        if (this.getNullFormat() != null) {
            tbl.setSerdeParam("serialization.null.format", this.getNullFormat());
        }
        if (this.getSerdeProps() != null) {
            for (Map.Entry<String, String> m : this.getSerdeProps().entrySet()) {
                tbl.setSerdeParam(m.getKey(), m.getValue());
            }
        }
        if (this.getCols() != null) {
            tbl.setFields(this.getCols());
        }
        if (this.getBucketCols() != null) {
            tbl.setBucketCols(this.getBucketCols());
        }
        if (this.getSortCols() != null) {
            tbl.setSortCols(this.getSortCols());
        }
        if (this.getComment() != null) {
            tbl.setProperty("comment", this.getComment());
        }
        if (this.getLocation() != null) {
            tbl.setDataLocation(new Path(this.getLocation()));
        }
        if (this.getSkewedColNames() != null) {
            tbl.setSkewedColNames(this.getSkewedColNames());
        }
        if (this.getSkewedColValues() != null) {
            tbl.setSkewedColValues(this.getSkewedColValues());
        }
        tbl.getTTable().setTemporary(this.isTemporary());
        tbl.setStoredAsSubDirectories(this.isStoredAsSubDirectories());
        tbl.setInputFormatClass(this.getInputFormat());
        tbl.setOutputFormatClass(this.getOutputFormat());
        if (this.getInputFormat() != null && !this.getInputFormat().isEmpty()) {
            tbl.getTTable().getSd().setInputFormat(tbl.getInputFormatClass().getName());
        }
        if (this.getOutputFormat() != null && !this.getOutputFormat().isEmpty()) {
            tbl.getTTable().getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
        }
        if (CreateTableOperation.doesTableNeedLocation(tbl)) {
            CreateTableOperation.makeLocationQualified(tbl, conf);
        }
        if (this.isExternal()) {
            tbl.setProperty("EXTERNAL", "TRUE");
            tbl.setTableType(TableType.EXTERNAL_TABLE);
            if (tbl.isPartitioned() && tbl.getProperty("discover.partitions") == null) {
                tbl.setProperty("discover.partitions", "true");
            }
        }
        if (tbl.getBucketCols() != null && tbl.getSortCols() != null) {
            List<String> bucketCols = tbl.getBucketCols();
            List<Order> sortCols = tbl.getSortCols();
            if (sortCols.size() > 0 && sortCols.size() >= bucketCols.size()) {
                boolean found = true;
                for (String bucketCol : bucketCols) {
                    boolean colFound = false;
                    for (int i = 0; i < bucketCols.size(); ++i) {
                        if (!bucketCol.equals(sortCols.get(i).getCol())) continue;
                        colFound = true;
                        break;
                    }
                    if (colFound) continue;
                    found = false;
                    break;
                }
                if (found) {
                    tbl.setProperty("SORTBUCKETCOLSPREFIX", "TRUE");
                }
            }
        }
        if (this.colStats != null) {
            ColumnStatisticsDesc colStatsDesc = new ColumnStatisticsDesc(this.colStats.getStatsDesc());
            colStatsDesc.setCatName(tbl.getCatName());
            colStatsDesc.setDbName(tbl.getDbName());
            colStatsDesc.setTableName(tbl.getTableName());
            String engine = this.colStats.getEngine();
            if (engine == null) {
                engine = "hive";
            }
            ColumnStatistics columnStatistics = new ColumnStatistics(colStatsDesc, this.colStats.getStatsObj());
            columnStatistics.setEngine(engine);
            tbl.getTTable().setColStats(columnStatistics);
            if (this.replWriteId > 0L) {
                tbl.getTTable().setWriteId(this.replWriteId.longValue());
            }
        }
        if (this.replicationSpec == null || !this.replicationSpec.isInReplicationScope()) {
            if (!this.isCTAS && (tbl.getPath() == null || tbl.isEmpty() && !this.isExternal())) {
                if (!tbl.isPartitioned() && conf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
                    StatsSetupConst.setStatsStateForCreateTable((Map)tbl.getTTable().getParameters(), (List)MetaStoreUtils.getColumnNames(tbl.getCols()), (String)"true");
                }
            } else {
                StatsSetupConst.setStatsStateForCreateTable((Map)tbl.getTTable().getParameters(), null, (String)"false");
            }
        }
        if (this.ownerName != null) {
            tbl.setOwner(this.ownerName);
        }
        return tbl;
    }

    public void setInitialMmWriteId(Long mmWriteId) {
        this.initialMmWriteId = mmWriteId;
    }

    public Long getInitialMmWriteId() {
        return this.initialMmWriteId;
    }

    public FileSinkDesc getAndUnsetWriter() {
        FileSinkDesc fsd = this.writer;
        this.writer = null;
        return fsd;
    }

    public void setWriter(FileSinkDesc writer) {
        this.writer = writer;
    }

    public Long getReplWriteId() {
        return this.replWriteId;
    }

    public void setReplWriteId(Long replWriteId) {
        this.replWriteId = replWriteId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }
}

