/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.constraint;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UnparseTranslator;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeTypeCheck;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public final class ConstraintsUtils {
    private static final int CONSTRAINT_MAX_LENGTH = 255;
    private static final int DEFAULT_MAX_LEN = 255;

    private ConstraintsUtils() {
        throw new UnsupportedOperationException("ConstraintsUtils should not be instantiated!");
    }

    public static void processPrimaryKeys(TableName tableName, ASTNode child, List<SQLPrimaryKey> primaryKeys) throws SemanticException {
        List<ConstraintInfo> primaryKeyInfos = ConstraintsUtils.generateConstraintInfos(child);
        ConstraintsUtils.constraintInfosToPrimaryKeys(tableName, primaryKeyInfos, primaryKeys);
    }

    public static void processPrimaryKeys(TableName tableName, ASTNode child, List<String> columnNames, List<SQLPrimaryKey> primaryKeys) throws SemanticException {
        List<ConstraintInfo> primaryKeyInfos = ConstraintsUtils.generateConstraintInfos(child, columnNames, null, null);
        ConstraintsUtils.constraintInfosToPrimaryKeys(tableName, primaryKeyInfos, primaryKeys);
    }

    private static void constraintInfosToPrimaryKeys(TableName tableName, List<ConstraintInfo> primaryKeyInfos, List<SQLPrimaryKey> primaryKeys) {
        int i = 1;
        for (ConstraintInfo primaryKeyInfo : primaryKeyInfos) {
            primaryKeys.add(new SQLPrimaryKey(tableName.getDb(), tableName.getTable(), primaryKeyInfo.colName, i++, primaryKeyInfo.constraintName, primaryKeyInfo.enable, primaryKeyInfo.validate, primaryKeyInfo.rely));
        }
    }

    public static void processUniqueConstraints(TableName tableName, ASTNode child, List<SQLUniqueConstraint> uniqueConstraints) throws SemanticException {
        List<ConstraintInfo> uniqueInfos = ConstraintsUtils.generateConstraintInfos(child);
        ConstraintsUtils.constraintInfosToUniqueConstraints(tableName, uniqueInfos, uniqueConstraints);
    }

    public static void processUniqueConstraints(TableName tableName, ASTNode child, List<String> columnNames, List<SQLUniqueConstraint> uniqueConstraints) throws SemanticException {
        List<ConstraintInfo> uniqueInfos = ConstraintsUtils.generateConstraintInfos(child, columnNames, null, null);
        ConstraintsUtils.constraintInfosToUniqueConstraints(tableName, uniqueInfos, uniqueConstraints);
    }

    private static void constraintInfosToUniqueConstraints(TableName tableName, List<ConstraintInfo> uniqueInfos, List<SQLUniqueConstraint> uniqueConstraints) {
        int i = 1;
        for (ConstraintInfo uniqueInfo : uniqueInfos) {
            uniqueConstraints.add(new SQLUniqueConstraint(tableName.getCat(), tableName.getDb(), tableName.getTable(), uniqueInfo.colName, i++, uniqueInfo.constraintName, uniqueInfo.enable, uniqueInfo.validate, uniqueInfo.rely));
        }
    }

    public static void processCheckConstraints(TableName tableName, ASTNode child, List<String> columnNames, List<SQLCheckConstraint> checkConstraints, ASTNode typeChild, TokenRewriteStream tokenRewriteStream) throws SemanticException {
        List<ConstraintInfo> checkInfos = ConstraintsUtils.generateConstraintInfos(child, columnNames, typeChild, tokenRewriteStream);
        ConstraintsUtils.constraintInfosToCheckConstraints(tableName, checkInfos, checkConstraints);
    }

    private static void constraintInfosToCheckConstraints(TableName tableName, List<ConstraintInfo> checkInfos, List<SQLCheckConstraint> checkConstraints) {
        for (ConstraintInfo checkInfo : checkInfos) {
            checkConstraints.add(new SQLCheckConstraint(tableName.getCat(), tableName.getDb(), tableName.getTable(), checkInfo.colName, checkInfo.defaultValue, checkInfo.constraintName, checkInfo.enable, checkInfo.validate, checkInfo.rely));
        }
    }

    public static void processDefaultConstraints(TableName tableName, ASTNode child, List<String> columnNames, List<SQLDefaultConstraint> defaultConstraints, ASTNode typeChild, TokenRewriteStream tokenRewriteStream) throws SemanticException {
        List<ConstraintInfo> defaultInfos = ConstraintsUtils.generateConstraintInfos(child, columnNames, typeChild, tokenRewriteStream);
        ConstraintsUtils.constraintInfosToDefaultConstraints(tableName, defaultInfos, defaultConstraints);
    }

    private static void constraintInfosToDefaultConstraints(TableName tableName, List<ConstraintInfo> defaultInfos, List<SQLDefaultConstraint> defaultConstraints) {
        for (ConstraintInfo defaultInfo : defaultInfos) {
            defaultConstraints.add(new SQLDefaultConstraint(tableName.getCat(), tableName.getDb(), tableName.getTable(), defaultInfo.colName, defaultInfo.defaultValue, defaultInfo.constraintName, defaultInfo.enable, defaultInfo.validate, defaultInfo.rely));
        }
    }

    public static void processNotNullConstraints(TableName tableName, ASTNode child, List<String> columnNames, List<SQLNotNullConstraint> notNullConstraints) throws SemanticException {
        List<ConstraintInfo> notNullInfos = ConstraintsUtils.generateConstraintInfos(child, columnNames, null, null);
        ConstraintsUtils.constraintInfosToNotNullConstraints(tableName, notNullInfos, notNullConstraints);
    }

    private static void constraintInfosToNotNullConstraints(TableName tableName, List<ConstraintInfo> notNullInfos, List<SQLNotNullConstraint> notNullConstraints) {
        for (ConstraintInfo notNullInfo : notNullInfos) {
            notNullConstraints.add(new SQLNotNullConstraint(tableName.getCat(), tableName.getDb(), tableName.getTable(), notNullInfo.colName, notNullInfo.constraintName, notNullInfo.enable, notNullInfo.validate, notNullInfo.rely));
        }
    }

    private static List<ConstraintInfo> generateConstraintInfos(ASTNode child) throws SemanticException {
        ImmutableList.Builder columnNames = ImmutableList.builder();
        for (int j = 0; j < child.getChild(0).getChildCount(); ++j) {
            Tree columnName = child.getChild(0).getChild(j);
            BaseSemanticAnalyzer.checkColumnName(columnName.getText());
            columnNames.add((Object)BaseSemanticAnalyzer.unescapeIdentifier(columnName.getText().toLowerCase()));
        }
        return ConstraintsUtils.generateConstraintInfos(child, (List<String>)columnNames.build(), null, null);
    }

    private static List<ConstraintInfo> generateConstraintInfos(ASTNode child, List<String> columnNames, ASTNode typeChildForDefault, TokenRewriteStream tokenRewriteStream) throws SemanticException {
        String constraintName = null;
        boolean enable = true;
        boolean validate = false;
        boolean rely = true;
        String checkOrDefaultValue = null;
        int childType = child.getToken().getType();
        for (int i = 0; i < child.getChildCount(); ++i) {
            ASTNode grandChild = (ASTNode)child.getChild(i);
            int type = grandChild.getToken().getType();
            if (type == 860) {
                constraintName = BaseSemanticAnalyzer.unescapeIdentifier(grandChild.getChild(0).getText().toLowerCase());
                continue;
            }
            if (type == 913) {
                enable = true;
                validate = false;
                continue;
            }
            if (type == 898) {
                enable = false;
                validate = false;
                rely = false;
                continue;
            }
            if (type == 1198) {
                validate = true;
                continue;
            }
            if (type == 993) {
                validate = false;
                continue;
            }
            if (type == 1056) {
                rely = true;
                continue;
            }
            if (type == 988) {
                rely = false;
                continue;
            }
            if (childType == 889) {
                checkOrDefaultValue = ConstraintsUtils.getDefaultValue(grandChild, typeChildForDefault, tokenRewriteStream);
                continue;
            }
            if (childType != 855) continue;
            checkOrDefaultValue = tokenRewriteStream.toOriginalString(grandChild.getTokenStartIndex(), grandChild.getTokenStopIndex());
        }
        if (constraintName != null && constraintName.length() > 255) {
            throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("Constraint name: " + constraintName + " exceeded maximum allowed length: " + 255));
        }
        if (checkOrDefaultValue != null && checkOrDefaultValue.length() > 255) {
            throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("Constraint value: " + checkOrDefaultValue + " exceeded maximum allowed length: " + 255));
        }
        if (enable && childType != 991 && childType != 889 && childType != 855) {
            throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("ENABLE/ENFORCED feature not supported yet. Please use DISABLE/NOT ENFORCED instead."));
        }
        if (validate) {
            throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("VALIDATE feature not supported yet. Please use NOVALIDATE instead."));
        }
        ArrayList<ConstraintInfo> constraintInfos = new ArrayList<ConstraintInfo>();
        if (columnNames == null) {
            constraintInfos.add(new ConstraintInfo(null, constraintName, enable, validate, rely, checkOrDefaultValue));
        } else {
            for (String columnName : columnNames) {
                constraintInfos.add(new ConstraintInfo(columnName, constraintName, enable, validate, rely, checkOrDefaultValue));
            }
        }
        return constraintInfos;
    }

    private static String getDefaultValue(ASTNode node, ASTNode typeChild, TokenRewriteStream tokenStream) throws SemanticException {
        TypeInfo colTypeInfo;
        TypeCheckCtx typeCheckCtx = new TypeCheckCtx(null);
        ExprNodeDesc defaultValExpr = ExprNodeTypeCheck.genExprNode(node, typeCheckCtx).get(node);
        if (defaultValExpr == null) {
            throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("Invalid Default value!"));
        }
        String defaultValueText = tokenStream.toOriginalString(node.getTokenStartIndex(), node.getTokenStopIndex());
        if (defaultValueText.length() > 255) {
            throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("Invalid Default value:  " + defaultValueText + " .Maximum character length allowed is " + 255 + " ."));
        }
        TypeInfo defaultValTypeInfo = defaultValExpr.getTypeInfo();
        if (!defaultValTypeInfo.equals((Object)(colTypeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)BaseSemanticAnalyzer.getTypeStringFromAST(typeChild))))) {
            throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("Invalid type: " + defaultValTypeInfo.getTypeName() + " for default value: " + defaultValueText + ". Please make sure that the type is compatible with column type: " + colTypeInfo.getTypeName()));
        }
        if (!ConstraintsUtils.isDefaultValueAllowed(defaultValExpr)) {
            throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("Invalid Default value: " + defaultValueText + ". DEFAULT only allows constant or function expressions"));
        }
        return defaultValueText;
    }

    private static boolean isDefaultValueAllowed(ExprNodeDesc defaultValExpr) {
        while (FunctionRegistry.isOpCast(defaultValExpr)) {
            defaultValExpr = defaultValExpr.getChildren().get(0);
        }
        if (defaultValExpr instanceof ExprNodeConstantDesc) {
            return true;
        }
        if (defaultValExpr instanceof ExprNodeGenericFuncDesc) {
            for (ExprNodeDesc argument : defaultValExpr.getChildren()) {
                if (ConstraintsUtils.isDefaultValueAllowed(argument)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void processForeignKeys(TableName tableName, ASTNode node, List<SQLForeignKey> foreignKeys) throws SemanticException {
        String constraintName = null;
        boolean enable = true;
        boolean validate = true;
        boolean rely = false;
        int fkIndex = -1;
        for (int i = 0; i < node.getChildCount(); ++i) {
            ASTNode grandChild = (ASTNode)node.getChild(i);
            int type = grandChild.getToken().getType();
            if (type == 860) {
                constraintName = BaseSemanticAnalyzer.unescapeIdentifier(grandChild.getChild(0).getText().toLowerCase());
                continue;
            }
            if (type == 913) {
                enable = true;
                validate = true;
                continue;
            }
            if (type == 898) {
                enable = false;
                validate = false;
                continue;
            }
            if (type == 1198) {
                validate = true;
                continue;
            }
            if (type == 993) {
                validate = false;
                continue;
            }
            if (type == 1056) {
                rely = true;
                continue;
            }
            if (type != 1137 || fkIndex != -1) continue;
            fkIndex = i;
        }
        if (enable) {
            throw new SemanticException(ErrorMsg.INVALID_FK_SYNTAX.getMsg("ENABLE feature not supported yet. Please use DISABLE instead."));
        }
        if (validate) {
            throw new SemanticException(ErrorMsg.INVALID_FK_SYNTAX.getMsg("VALIDATE feature not supported yet. Please use NOVALIDATE instead."));
        }
        int ptIndex = fkIndex + 1;
        int pkIndex = ptIndex + 1;
        if (node.getChild(fkIndex).getChildCount() != node.getChild(pkIndex).getChildCount()) {
            throw new SemanticException(ErrorMsg.INVALID_FK_SYNTAX.getMsg(" The number of foreign key columns should be same as number of parent key columns "));
        }
        TableName parentTblName = BaseSemanticAnalyzer.getQualifiedTableName((ASTNode)node.getChild(ptIndex));
        for (int j = 0; j < node.getChild(fkIndex).getChildCount(); ++j) {
            SQLForeignKey sqlForeignKey = new SQLForeignKey();
            sqlForeignKey.setFktable_db(tableName.getDb());
            sqlForeignKey.setFktable_name(tableName.getTable());
            Tree fkgrandChild = node.getChild(fkIndex).getChild(j);
            BaseSemanticAnalyzer.checkColumnName(fkgrandChild.getText());
            sqlForeignKey.setFkcolumn_name(BaseSemanticAnalyzer.unescapeIdentifier(fkgrandChild.getText().toLowerCase()));
            sqlForeignKey.setPktable_db(parentTblName.getDb());
            sqlForeignKey.setPktable_name(parentTblName.getTable());
            Tree pkgrandChild = node.getChild(pkIndex).getChild(j);
            sqlForeignKey.setPkcolumn_name(BaseSemanticAnalyzer.unescapeIdentifier(pkgrandChild.getText().toLowerCase()));
            sqlForeignKey.setKey_seq(j + 1);
            sqlForeignKey.setFk_name(constraintName);
            sqlForeignKey.setEnable_cstr(enable);
            sqlForeignKey.setValidate_cstr(validate);
            sqlForeignKey.setRely_cstr(rely);
            foreignKeys.add(sqlForeignKey);
        }
    }

    public static void validateCheckConstraint(List<FieldSchema> columns, List<SQLCheckConstraint> checkConstraints, Configuration conf) throws SemanticException {
        RowResolver rr = new RowResolver();
        for (FieldSchema column : columns) {
            ColumnInfo ci = new ColumnInfo(column.getName(), TypeInfoUtils.getTypeInfoFromTypeString((String)column.getType()), null, false);
            rr.put(null, column.getName(), ci);
        }
        TypeCheckCtx typeCheckCtx = new TypeCheckCtx(rr);
        UnparseTranslator unparseTranslator = new UnparseTranslator(conf);
        typeCheckCtx.setUnparseTranslator(unparseTranslator);
        for (SQLCheckConstraint cc : checkConstraints) {
            try {
                ParseDriver parseDriver = new ParseDriver();
                ASTNode checkExprAST = parseDriver.parseExpression(cc.getCheck_expression());
                ConstraintsUtils.validateCheckExprAST(checkExprAST);
                Map<ASTNode, ExprNodeDesc> genExprs = ExprNodeTypeCheck.genExprNode(checkExprAST, typeCheckCtx);
                ExprNodeDesc checkExpr = genExprs.get(checkExprAST);
                if (checkExpr == null) {
                    throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("Invalid type for CHECK constraint: ") + cc.getCheck_expression());
                }
                if (checkExpr.getTypeInfo().getTypeName() != "boolean") {
                    throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("Only boolean type is supported for CHECK constraint: ") + cc.getCheck_expression() + ". Found: " + checkExpr.getTypeInfo().getTypeName());
                }
                ConstraintsUtils.validateCheckExpr(checkExpr);
            }
            catch (Exception e) {
                throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("Invalid CHECK constraint expression: ") + cc.getCheck_expression() + ". " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void validateCheckExprAST(ASTNode checkExpr) throws SemanticException {
        if (checkExpr == null) {
            return;
        }
        if (checkExpr.getType() == 1127) {
            throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("Subqueries are not allowed in Check Constraints"));
        }
        for (int i = 0; i < checkExpr.getChildCount(); ++i) {
            ConstraintsUtils.validateCheckExprAST((ASTNode)checkExpr.getChild(i));
        }
    }

    private static void validateCheckExpr(ExprNodeDesc checkExpr) throws SemanticException {
        if (checkExpr instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc funcDesc = (ExprNodeGenericFuncDesc)checkExpr;
            boolean isBuiltIn = FunctionRegistry.isBuiltInFuncExpr(funcDesc);
            boolean isPermanent = FunctionRegistry.isPermanentFunction(funcDesc);
            if (!isBuiltIn && !isPermanent) {
                throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("Temporary UDFs are not allowed in Check Constraints"));
            }
            if (FunctionRegistry.impliesOrder(funcDesc.getFuncText())) {
                throw new SemanticException(ErrorMsg.INVALID_CSTR_SYNTAX.getMsg("Window functions are not allowed in Check Constraints"));
            }
        }
        if (checkExpr.getChildren() == null) {
            return;
        }
        for (ExprNodeDesc childExpr : checkExpr.getChildren()) {
            ConstraintsUtils.validateCheckExpr(childExpr);
        }
    }

    public static boolean hasEnabledOrValidatedConstraints(List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) {
        if (notNullConstraints != null) {
            for (SQLNotNullConstraint nnC : notNullConstraints) {
                if (!nnC.isEnable_cstr() && !nnC.isValidate_cstr()) continue;
                return true;
            }
        }
        if (defaultConstraints != null && !defaultConstraints.isEmpty()) {
            return true;
        }
        return checkConstraints != null && !checkConstraints.isEmpty();
    }

    private static class ConstraintInfo {
        final String colName;
        final String constraintName;
        final boolean enable;
        final boolean validate;
        final boolean rely;
        final String defaultValue;

        ConstraintInfo(String colName, String constraintName, boolean enable, boolean validate, boolean rely, String defaultValue) {
            this.colName = colName;
            this.constraintName = constraintName;
            this.enable = enable;
            this.validate = validate;
            this.rely = rely;
            this.defaultValue = defaultValue;
        }
    }
}

