/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.function;

import java.util.List;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public abstract class AbstractFunctionAnalyzer
extends BaseSemanticAnalyzer {
    public AbstractFunctionAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    protected void addEntities(String functionName, String className, boolean isTemporary, List<ResourceUri> resources) throws SemanticException {
        Database database = null;
        if (!isTemporary) {
            try {
                String[] qualifiedNameParts = FunctionUtils.getQualifiedFunctionNameParts(functionName);
                String databaseName = qualifiedNameParts[0];
                functionName = qualifiedNameParts[1];
                database = this.getDatabase(databaseName);
            }
            catch (HiveException e) {
                this.LOG.error("Failed to get database ", (Throwable)e);
                throw new SemanticException((Throwable)e);
            }
        }
        if (database != null) {
            this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_NO_LOCK));
        }
        this.outputs.add(new WriteEntity(database, functionName, className, Entity.Type.FUNCTION, WriteEntity.WriteType.DDL_NO_LOCK));
        if (resources != null) {
            for (ResourceUri resource : resources) {
                String uriPath = resource.getUri();
                this.outputs.add(this.toWriteEntity(uriPath));
            }
        }
    }
}

