/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.desc;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.formatting.MapBuilder;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hive.common.util.HiveStringUtils;

abstract class DescDatabaseFormatter {
    DescDatabaseFormatter() {
    }

    static DescDatabaseFormatter getFormatter(HiveConf conf) {
        if (MetaDataFormatUtils.isJson(conf)) {
            return new JsonDescDatabaseFormatter();
        }
        return new TextDescDatabaseFormatter();
    }

    abstract void showDatabaseDescription(DataOutputStream var1, String var2, String var3, String var4, String var5, String var6, PrincipalType var7, Map<String, String> var8) throws HiveException;

    static class TextDescDatabaseFormatter
    extends DescDatabaseFormatter {
        TextDescDatabaseFormatter() {
        }

        @Override
        void showDatabaseDescription(DataOutputStream out, String database, String comment, String location, String managedLocation, String ownerName, PrincipalType ownerType, Map<String, String> params) throws HiveException {
            try {
                out.write(database.getBytes(StandardCharsets.UTF_8));
                out.write(9);
                if (comment != null) {
                    out.write(HiveStringUtils.escapeJava((String)comment).getBytes(StandardCharsets.UTF_8));
                }
                out.write(9);
                if (location != null) {
                    out.write(location.getBytes(StandardCharsets.UTF_8));
                }
                out.write(9);
                if (managedLocation != null) {
                    out.write(managedLocation.getBytes(StandardCharsets.UTF_8));
                }
                out.write(9);
                if (ownerName != null) {
                    out.write(ownerName.getBytes(StandardCharsets.UTF_8));
                }
                out.write(9);
                if (ownerType != null) {
                    out.write(ownerType.name().getBytes(StandardCharsets.UTF_8));
                }
                out.write(9);
                if (MapUtils.isNotEmpty(params)) {
                    out.write(params.toString().getBytes(StandardCharsets.UTF_8));
                }
                out.write(10);
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
        }
    }

    static class JsonDescDatabaseFormatter
    extends DescDatabaseFormatter {
        JsonDescDatabaseFormatter() {
        }

        @Override
        void showDatabaseDescription(DataOutputStream out, String database, String comment, String location, String managedLocation, String ownerName, PrincipalType ownerType, Map<String, String> params) throws HiveException {
            MapBuilder builder = MapBuilder.create().put("database", database).put("comment", comment).put("location", location);
            if (managedLocation != null) {
                builder.put("managedLocation", managedLocation);
            }
            if (ownerName != null) {
                builder.put("owner", ownerName);
            }
            if (ownerType != null) {
                builder.put("ownerType", ownerType.name());
            }
            if (MapUtils.isNotEmpty(params)) {
                builder.put("params", params);
            }
            ShowUtils.asJson(out, builder.build());
        }
    }
}

