/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.desc;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Describe Database", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class DescDatabaseDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DESC_DATABASE_SCHEMA = "db_name,comment,location,managedLocation,owner_name,owner_type#string:string:string:string:string:string";
    public static final String DESC_DATABASE_SCHEMA_EXTENDED = "db_name,comment,location,managedLocation,owner_name,owner_type,parameters#string:string:string:string:string:string:string";
    private final String resFile;
    private final String dbName;
    private final boolean isExtended;

    public DescDatabaseDesc(Path resFile, String dbName, boolean isExtended) {
        this.resFile = resFile.toString();
        this.dbName = dbName;
        this.isExtended = isExtended;
    }

    @Explain(displayName="extended", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isExtended() {
        return this.isExtended;
    }

    @Explain(displayName="database", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getDatabaseName() {
        return this.dbName;
    }

    @Explain(displayName="result file", explainLevels={Explain.Level.EXTENDED})
    public String getResFile() {
        return this.resFile;
    }

    public String getSchema() {
        return this.isExtended ? DESC_DATABASE_SCHEMA_EXTENDED : DESC_DATABASE_SCHEMA;
    }
}

