/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.create;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.database.create.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;

public class CreateDatabaseOperation
extends DDLOperation<CreateDatabaseDesc> {
    private static final String DATABASE_PATH_SUFFIX = ".db";

    public CreateDatabaseOperation(DDLOperationContext context, CreateDatabaseDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Database database = new Database(((CreateDatabaseDesc)this.desc).getName(), ((CreateDatabaseDesc)this.desc).getComment(), ((CreateDatabaseDesc)this.desc).getLocationUri(), ((CreateDatabaseDesc)this.desc).getDatabaseProperties());
        database.setOwnerName(SessionState.getUserFromAuthenticator());
        database.setOwnerType(PrincipalType.USER);
        if (((CreateDatabaseDesc)this.desc).getManagedLocationUri() != null) {
            database.setManagedLocationUri(((CreateDatabaseDesc)this.desc).getManagedLocationUri());
        }
        try {
            this.makeLocationQualified(database);
            if (database.getLocationUri().equalsIgnoreCase(database.getManagedLocationUri())) {
                throw new HiveException("Managed and external locations for database cannot be the same");
            }
            this.context.getDb().createDatabase(database, ((CreateDatabaseDesc)this.desc).getIfNotExists());
        }
        catch (AlreadyExistsException ex) {
            throw new HiveException((Throwable)ex, ErrorMsg.DATABASE_ALREADY_EXISTS, new String[]{((CreateDatabaseDesc)this.desc).getName()});
        }
        return 0;
    }

    private void makeLocationQualified(Database database) throws HiveException {
        if (database.isSetLocationUri()) {
            database.setLocationUri(Utilities.getQualifiedPath(this.context.getConf(), new Path(database.getLocationUri())));
        } else {
            String rootDir = MetastoreConf.getVar((Configuration)this.context.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE_EXTERNAL);
            if (rootDir == null || rootDir.trim().isEmpty()) {
                LOG.warn(String.format("%s is not set, falling back to %s. This could cause external tables to use to managed tablespace.", MetastoreConf.ConfVars.WAREHOUSE_EXTERNAL.getVarname(), MetastoreConf.ConfVars.WAREHOUSE.getVarname()));
                rootDir = MetastoreConf.getVar((Configuration)this.context.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE);
            }
            Path path = new Path(rootDir, database.getName().toLowerCase() + DATABASE_PATH_SUFFIX);
            String qualifiedPath = Utilities.getQualifiedPath(this.context.getConf(), path);
            database.setLocationUri(qualifiedPath);
        }
        if (database.isSetManagedLocationUri()) {
            database.setManagedLocationUri(Utilities.getQualifiedPath(this.context.getConf(), new Path(database.getManagedLocationUri())));
        }
    }
}

