/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.create;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Create Database", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateDatabaseDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final String comment;
    private final String locationUri;
    private final String managedLocationUri;
    private final boolean ifNotExists;
    private final Map<String, String> dbProperties;

    public CreateDatabaseDesc(String databaseName, String comment, String locationUri, String managedLocationUri, boolean ifNotExists, Map<String, String> dbProperties) {
        this.databaseName = databaseName;
        this.comment = comment;
        this.locationUri = locationUri;
        this.managedLocationUri = managedLocationUri;
        this.ifNotExists = ifNotExists;
        this.dbProperties = dbProperties;
    }

    @Explain(displayName="if not exists", displayOnlyOnTrue=true)
    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public Map<String, String> getDatabaseProperties() {
        return this.dbProperties;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getName() {
        return this.databaseName;
    }

    @Explain(displayName="comment")
    public String getComment() {
        return this.comment;
    }

    @Explain(displayName="locationUri")
    public String getLocationUri() {
        return this.locationUri;
    }

    @Explain(displayName="managed location uri")
    public String getManagedLocationUri() {
        return this.managedLocationUri;
    }
}

