/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.alter.owner;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.database.alter.AbstractAlterDatabaseAnalyzer;
import org.apache.hadoop.hive.ql.ddl.database.alter.owner.AlterDatabaseSetOwnerDesc;
import org.apache.hadoop.hive.ql.ddl.privilege.PrincipalDesc;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.authorization.AuthorizationParseUtils;

@DDLSemanticAnalyzerFactory.DDLType(types={778})
public class AlterDatabaseSetOwnerAnalyzer
extends AbstractAlterDatabaseAnalyzer {
    public AlterDatabaseSetOwnerAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        String databaseName = AlterDatabaseSetOwnerAnalyzer.getUnescapedName((ASTNode)root.getChild(0));
        PrincipalDesc principalDesc = AuthorizationParseUtils.getPrincipalDesc((ASTNode)root.getChild(1));
        if (principalDesc.getName() == null) {
            throw new SemanticException("Owner name can't be null in alter database set owner command");
        }
        if (principalDesc.getType() == null) {
            throw new SemanticException("Owner type can't be null in alter database set owner command");
        }
        AlterDatabaseSetOwnerDesc desc = new AlterDatabaseSetOwnerDesc(databaseName, principalDesc, null);
        this.addAlterDatabaseDesc(desc);
    }
}

