/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class DDLSemanticAnalyzerFactory {
    private static final String DDL_ROOT = "org.apache.hadoop.hive.ql.ddl";
    private static final Map<Integer, Class<? extends BaseSemanticAnalyzer>> TYPE_TO_ANALYZER = new HashMap<Integer, Class<? extends BaseSemanticAnalyzer>>();
    private static final Map<Integer, Class<? extends DDLSemanticAnalyzerCategory>> TYPE_TO_ANALYZERCATEGORY = new HashMap<Integer, Class<? extends DDLSemanticAnalyzerCategory>>();

    private DDLSemanticAnalyzerFactory() {
        throw new UnsupportedOperationException("DDLSemanticAnalyzerFactory should not be instantiated");
    }

    public static boolean handles(ASTNode root) {
        return DDLSemanticAnalyzerFactory.getAnalyzerClass(root, null) != null;
    }

    public static BaseSemanticAnalyzer getAnalyzer(ASTNode root, QueryState queryState) {
        Class<? extends BaseSemanticAnalyzer> analyzerClass = DDLSemanticAnalyzerFactory.getAnalyzerClass(root, queryState);
        try {
            BaseSemanticAnalyzer analyzer = analyzerClass.getConstructor(QueryState.class).newInstance(queryState);
            return analyzer;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public static BaseSemanticAnalyzer getAnalyzer(ASTNode root, QueryState queryState, Hive db) {
        Class<? extends BaseSemanticAnalyzer> analyzerClass = DDLSemanticAnalyzerFactory.getAnalyzerClass(root, queryState);
        try {
            BaseSemanticAnalyzer analyzer = analyzerClass.getConstructor(QueryState.class, Hive.class).newInstance(queryState, db);
            return analyzer;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<? extends BaseSemanticAnalyzer> getAnalyzerClass(ASTNode root, QueryState queryState) {
        if (TYPE_TO_ANALYZER.containsKey(root.getType())) {
            return TYPE_TO_ANALYZER.get(root.getType());
        }
        if (TYPE_TO_ANALYZERCATEGORY.containsKey(root.getType())) {
            Class<? extends DDLSemanticAnalyzerCategory> analyzerCategoryClass = TYPE_TO_ANALYZERCATEGORY.get(root.getType());
            try {
                DDLSemanticAnalyzerCategory analyzerCategory = analyzerCategoryClass.newInstance();
                int actualType = analyzerCategory.getType(root);
                if (TYPE_TO_ANALYZER.containsKey(actualType)) {
                    if (queryState != null) {
                        queryState.setCommandType(HiveOperation.operationForToken(actualType));
                    }
                    return TYPE_TO_ANALYZER.get(actualType);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    static {
        Set analyzerClasses1 = new Reflections(DDL_ROOT, new Scanner[0]).getSubTypesOf(BaseSemanticAnalyzer.class);
        Set analyzerClasses2 = new Reflections(DDL_ROOT, new Scanner[0]).getSubTypesOf(CalcitePlanner.class);
        Sets.SetView analyzerClasses = Sets.union((Set)analyzerClasses1, (Set)analyzerClasses2);
        for (Class analyzerClass : analyzerClasses) {
            if (Modifier.isAbstract(analyzerClass.getModifiers())) continue;
            DDLType ddlType = analyzerClass.getAnnotation(DDLType.class);
            for (int type : ddlType.types()) {
                if (TYPE_TO_ANALYZER.containsKey(type)) {
                    throw new IllegalStateException("Type " + type + " is declared more than once in different DDLType annotations.");
                }
                TYPE_TO_ANALYZER.put(type, analyzerClass);
            }
        }
        Set analyzerCategoryClasses = new Reflections(DDL_ROOT, new Scanner[0]).getSubTypesOf(DDLSemanticAnalyzerCategory.class);
        for (Class analyzerCategoryClass : analyzerCategoryClasses) {
            if (Modifier.isAbstract(analyzerCategoryClass.getModifiers())) continue;
            DDLType ddlType = analyzerCategoryClass.getAnnotation(DDLType.class);
            for (int type : ddlType.types()) {
                if (TYPE_TO_ANALYZERCATEGORY.containsKey(type)) {
                    throw new IllegalStateException("Type " + type + " is declared more than once in different DDLType annotations for categories.");
                }
                TYPE_TO_ANALYZERCATEGORY.put(type, analyzerCategoryClass);
            }
        }
    }

    public static interface DDLSemanticAnalyzerCategory {
        public int getType(ASTNode var1);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DDLType {
        public int[] types() default {};
    }
}

