/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.HiveDriverRunHook;
import org.apache.hadoop.hive.ql.HiveDriverRunHookContext;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HiveHooks;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.MetricsQueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookContextImpl;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookWithParseHooks;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.common.util.HiveStringUtils;

public class HookRunner {
    private static final String CLASS_NAME = Driver.class.getName();
    private final HiveConf conf;
    private final HiveHooks hooks;

    HookRunner(HiveConf conf, SessionState.LogHelper console) {
        this.conf = conf;
        this.hooks = new HiveHooks(conf, console);
        if (conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_METRICS_ENABLED)) {
            this.addLifeTimeHook(new MetricsQueryLifeTimeHook());
        }
    }

    void runBeforeParseHook(String command) {
        List queryHooks = this.hooks.getHooks(HookContext.HookType.QUERY_LIFETIME_HOOKS);
        if (!queryHooks.isEmpty()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).build();
            for (QueryLifeTimeHook hook : queryHooks) {
                if (!(hook instanceof QueryLifeTimeHookWithParseHooks)) continue;
                ((QueryLifeTimeHookWithParseHooks)hook).beforeParse(qhc);
            }
        }
    }

    void runAfterParseHook(String command, boolean parseError) {
        List queryHooks = this.hooks.getHooks(HookContext.HookType.QUERY_LIFETIME_HOOKS);
        if (!queryHooks.isEmpty()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).build();
            for (QueryLifeTimeHook hook : queryHooks) {
                if (!(hook instanceof QueryLifeTimeHookWithParseHooks)) continue;
                ((QueryLifeTimeHookWithParseHooks)hook).afterParse(qhc, parseError);
            }
        }
    }

    void runBeforeCompileHook(String command) {
        List queryHooks = this.hooks.getHooks(HookContext.HookType.QUERY_LIFETIME_HOOKS);
        if (!queryHooks.isEmpty()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).build();
            for (QueryLifeTimeHook hook : queryHooks) {
                hook.beforeCompile(qhc);
            }
        }
    }

    void runAfterCompilationHook(String command, boolean compileError) {
        List queryHooks = this.hooks.getHooks(HookContext.HookType.QUERY_LIFETIME_HOOKS);
        if (!queryHooks.isEmpty()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).build();
            for (QueryLifeTimeHook hook : queryHooks) {
                hook.afterCompile(qhc, compileError);
            }
        }
    }

    void runBeforeExecutionHook(String command, HookContext hookContext) {
        List queryHooks = this.hooks.getHooks(HookContext.HookType.QUERY_LIFETIME_HOOKS);
        if (!queryHooks.isEmpty()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).withHookContext(hookContext).build();
            for (QueryLifeTimeHook hook : queryHooks) {
                hook.beforeExecution(qhc);
            }
        }
    }

    void runAfterExecutionHook(String command, HookContext hookContext, boolean executionError) {
        List queryHooks = this.hooks.getHooks(HookContext.HookType.QUERY_LIFETIME_HOOKS);
        if (!queryHooks.isEmpty()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).withHookContext(hookContext).build();
            for (QueryLifeTimeHook hook : queryHooks) {
                hook.afterExecution(qhc, executionError);
            }
        }
    }

    public ASTNode runPreAnalyzeHooks(HiveSemanticAnalyzerHookContext hookCtx, ASTNode tree) throws HiveException {
        try {
            for (HiveSemanticAnalyzerHook hook : this.hooks.getHooks(HookContext.HookType.SEMANTIC_ANALYZER_HOOK, HiveSemanticAnalyzerHook.class)) {
                tree = hook.preAnalyze(hookCtx, tree);
            }
            return tree;
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException("Error while invoking PreAnalyzeHooks:" + HiveStringUtils.stringifyException((Throwable)e), (Throwable)e);
        }
    }

    public boolean hasPreAnalyzeHooks() {
        return !this.hooks.getHooks(HookContext.HookType.SEMANTIC_ANALYZER_HOOK).isEmpty();
    }

    public void runPostAnalyzeHooks(HiveSemanticAnalyzerHookContext hookCtx, List<Task<?>> allRootTasks) throws HiveException {
        try {
            for (HiveSemanticAnalyzerHook hook : this.hooks.getHooks(HookContext.HookType.SEMANTIC_ANALYZER_HOOK, HiveSemanticAnalyzerHook.class)) {
                hook.postAnalyze(hookCtx, allRootTasks);
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException("Error while invoking PostAnalyzeHooks:" + HiveStringUtils.stringifyException((Throwable)e), (Throwable)e);
        }
    }

    public void runPreDriverHooks(HiveDriverRunHookContext hookContext) throws HiveException {
        try {
            for (HiveDriverRunHook driverRunHook : this.hooks.getHooks(HookContext.HookType.DRIVER_RUN_HOOKS, HiveDriverRunHook.class)) {
                driverRunHook.preDriverRun(hookContext);
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException("Error while invoking PreDriverHooks:" + HiveStringUtils.stringifyException((Throwable)e), (Throwable)e);
        }
    }

    public void runPostDriverHooks(HiveDriverRunHookContext hookContext) throws HiveException {
        try {
            for (HiveDriverRunHook driverRunHook : this.hooks.getHooks(HookContext.HookType.DRIVER_RUN_HOOKS, HiveDriverRunHook.class)) {
                driverRunHook.postDriverRun(hookContext);
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException("Error while invoking PostDriverHooks:" + HiveStringUtils.stringifyException((Throwable)e), (Throwable)e);
        }
    }

    public void runPreHooks(HookContext hookContext) throws HiveException {
        HookRunner.invokeGeneralHook(this.hooks.getHooks(HookContext.HookType.PRE_EXEC_HOOK), "PreHook.", hookContext);
    }

    public void runPostExecHooks(HookContext hookContext) throws HiveException {
        HookRunner.invokeGeneralHook(this.hooks.getHooks(HookContext.HookType.POST_EXEC_HOOK), "PostHook.", hookContext);
    }

    public void runFailureHooks(HookContext hookContext) throws HiveException {
        HookRunner.invokeGeneralHook(this.hooks.getHooks(HookContext.HookType.ON_FAILURE_HOOK), "FailureHook.", hookContext);
    }

    private static void invokeGeneralHook(List<ExecuteWithHookContext> hooks, String prefix, HookContext hookContext) throws HiveException {
        if (hooks.isEmpty()) {
            return;
        }
        try {
            PerfLogger perfLogger = SessionState.getPerfLogger();
            for (ExecuteWithHookContext hook : hooks) {
                perfLogger.perfLogBegin(CLASS_NAME, prefix + hook.getClass().getName());
                hook.run(hookContext);
                perfLogger.perfLogEnd(CLASS_NAME, prefix + hook.getClass().getName());
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException("Error while invoking " + prefix + " hooks: " + HiveStringUtils.stringifyException((Throwable)e), (Throwable)e);
        }
    }

    public void addLifeTimeHook(QueryLifeTimeHook hook) {
        this.hooks.addHook(HookContext.HookType.QUERY_LIFETIME_HOOKS, hook);
    }

    public void addPreHook(ExecuteWithHookContext hook) {
        this.hooks.addHook(HookContext.HookType.PRE_EXEC_HOOK, hook);
    }

    public void addPostHook(ExecuteWithHookContext hook) {
        this.hooks.addHook(HookContext.HookType.POST_EXEC_HOOK, hook);
    }

    public void addOnFailureHook(ExecuteWithHookContext hook) {
        this.hooks.addHook(HookContext.HookType.ON_FAILURE_HOOK, hook);
    }

    public void addSemanticAnalyzerHook(HiveSemanticAnalyzerHook hook) {
        this.hooks.addHook(HookContext.HookType.SEMANTIC_ANALYZER_HOOK, hook);
    }
}

