/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.DriverState;
import org.apache.hadoop.hive.ql.DriverUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DriverTxnHandler {
    private static final String CLASS_NAME = Driver.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final SessionState.LogHelper CONSOLE = new SessionState.LogHelper(LOG);
    private static final int SHUTDOWN_HOOK_PRIORITY = 0;
    private final DriverContext driverContext;
    private final DriverState driverState;
    private final List<HiveLock> hiveLocks = new ArrayList<HiveLock>();
    private Context context;
    private Runnable txnRollbackRunner;

    DriverTxnHandler(DriverContext driverContext, DriverState driverState) {
        this.driverContext = driverContext;
        this.driverState = driverState;
    }

    void createTxnManager() throws CommandProcessorException {
        try {
            HiveTxnManager queryTxnManager;
            HiveTxnManager hiveTxnManager = queryTxnManager = this.driverContext.getInitTxnManager() != null ? this.driverContext.getInitTxnManager() : SessionState.get().initTxnMgr(this.driverContext.getConf());
            if (queryTxnManager instanceof Configurable) {
                ((Configurable)queryTxnManager).setConf((Configuration)this.driverContext.getConf());
            }
            this.driverContext.setTxnManager(queryTxnManager);
            this.driverContext.getQueryState().setTxnManager(queryTxnManager);
            ShutdownHookManager.removeShutdownHook((Runnable)this.txnRollbackRunner);
            this.txnRollbackRunner = new Runnable(){

                @Override
                public void run() {
                    try {
                        DriverTxnHandler.this.endTransactionAndCleanup(false, DriverTxnHandler.this.driverContext.getTxnManager());
                    }
                    catch (LockException e) {
                        LOG.warn("Exception when releasing locks in ShutdownHook for Driver: " + e.getMessage());
                    }
                }
            };
            ShutdownHookManager.addShutdownHook((Runnable)this.txnRollbackRunner, (int)0);
        }
        catch (LockException e) {
            ErrorMsg error = ErrorMsg.getErrorMsg((String)e.getMessage());
            String errorMessage = "FAILED: " + ((Object)((Object)e)).getClass().getSimpleName() + " [Error " + error.getErrorCode() + "]:";
            CONSOLE.printError(errorMessage, "\n" + StringUtils.stringifyException((Throwable)((Object)e)));
            throw DriverUtils.createProcessorException(this.driverContext, error.getErrorCode(), errorMessage, error.getSQLState(), (Throwable)((Object)e));
        }
    }

    void setContext(Context context) {
        this.context = context;
    }

    void cleanupTxnList() {
        this.driverContext.getConf().unset("hive.txn.valid.txns");
    }

    void acquireLocksIfNeeded() throws CommandProcessorException {
        if (this.requiresLock()) {
            this.acquireLocks();
        }
    }

    private boolean requiresLock() {
        if (!DriverUtils.checkConcurrency(this.driverContext)) {
            LOG.info("Concurrency mode is disabled, not creating a lock manager");
            return false;
        }
        if (this.isExplicitLockOperation()) {
            return false;
        }
        if (!HiveConf.getBoolVar((Configuration)this.driverContext.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LOCK_MAPRED_ONLY)) {
            return true;
        }
        if (this.driverContext.getConf().get("hive.query.exclusive.lock") != null) {
            return true;
        }
        LinkedList tasks = new LinkedList();
        tasks.addAll(this.driverContext.getPlan().getRootTasks());
        while (tasks.peek() != null) {
            Task task = (Task)tasks.remove();
            if (task.requireLock()) {
                return true;
            }
            if (task instanceof ConditionalTask) {
                tasks.addAll(((ConditionalTask)task).getListTasks());
            }
            if (task.getChildTasks() == null) continue;
            tasks.addAll(task.getChildTasks());
        }
        return false;
    }

    private boolean isExplicitLockOperation() {
        HiveOperation currentOpt = this.driverContext.getPlan().getOperation();
        if (currentOpt != null) {
            switch (currentOpt) {
                case LOCKDB: 
                case UNLOCKDB: 
                case LOCKTABLE: 
                case UNLOCKTABLE: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void acquireLocks() throws CommandProcessorException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(CLASS_NAME, "acquireReadWriteLocks");
        if (!this.driverContext.getTxnManager().isTxnOpen() && this.driverContext.getTxnManager().supportsAcid()) {
            return;
        }
        try {
            this.setWriteIdForAcidFileSinks();
            this.allocateWriteIdForAcidAnalyzeTable();
            boolean hasAcidDdl = this.setWriteIdForAcidDdl();
            this.acquireLocksInternal();
            if (this.driverContext.getPlan().hasAcidResourcesInQuery() || hasAcidDdl) {
                this.recordValidWriteIds();
            }
        }
        catch (Exception e) {
            String errorMessage;
            if (this.driverState.isDestroyed() || this.driverState.isAborted() || this.driverState.isClosed()) {
                errorMessage = String.format("Ignore lock acquisition related exception in terminal state (%s): %s", this.driverState.toString(), e.getMessage());
                CONSOLE.printInfo(errorMessage);
            } else {
                errorMessage = String.format("FAILED: Error in acquiring locks: %s", e.getMessage());
                CONSOLE.printError(errorMessage, "\n" + StringUtils.stringifyException((Throwable)e));
            }
            throw DriverUtils.createProcessorException(this.driverContext, 10, errorMessage, ErrorMsg.findSQLState((String)e.getMessage()), e);
        }
        finally {
            perfLogger.perfLogEnd(CLASS_NAME, "acquireReadWriteLocks");
        }
    }

    void setWriteIdForAcidFileSinks() throws SemanticException, LockException {
        if (!this.driverContext.getPlan().getAcidSinks().isEmpty()) {
            ArrayList<FileSinkDesc> acidSinks = new ArrayList<FileSinkDesc>(this.driverContext.getPlan().getAcidSinks());
            acidSinks.sort((fsd1, fsd2) -> fsd1.getDirName().compareTo((Object)fsd2.getDirName()));
            boolean isDirectInsertOn = false;
            for (FileSinkDesc acidSink : acidSinks) {
                if (!acidSink.isDirectInsert()) continue;
                isDirectInsertOn = true;
                break;
            }
            if (isDirectInsertOn) {
                acidSinks.sort((fsd1, fsd2) -> fsd1.getMoveTaskId().compareTo(fsd2.getMoveTaskId()));
            }
            int maxStmtId = -1;
            for (FileSinkDesc acidSink : acidSinks) {
                TableDesc tableInfo = acidSink.getTableInfo();
                TableName tableName = HiveTableName.of(tableInfo.getTableName());
                long writeId = this.driverContext.getTxnManager().getTableWriteId(tableName.getDb(), tableName.getTable());
                acidSink.setTableWriteId(writeId);
                acidSink.setStatementId(this.driverContext.getTxnManager().getStmtIdAndIncrement());
                maxStmtId = Math.max(acidSink.getStatementId(), maxStmtId);
                String unionAllSubdir = "/HIVE_UNION_SUBDIR_";
                if (!acidSink.getInsertOverwrite() || !acidSink.getDirName().toString().contains(unionAllSubdir) || !acidSink.isFullAcidTable()) continue;
                throw new UnsupportedOperationException("QueryId=" + this.driverContext.getPlan().getQueryId() + " is not supported due to OVERWRITE and UNION ALL.  Please use truncate + insert");
            }
            if (HiveConf.getBoolVar((Configuration)this.driverContext.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXTEND_BUCKET_ID_RANGE)) {
                for (FileSinkDesc each : acidSinks) {
                    each.setMaxStmtId(maxStmtId);
                }
            }
        }
    }

    private void allocateWriteIdForAcidAnalyzeTable() throws LockException {
        if (this.driverContext.getPlan().getAcidAnalyzeTable() != null) {
            Table table = this.driverContext.getPlan().getAcidAnalyzeTable().getTable();
            this.driverContext.getTxnManager().getTableWriteId(table.getDbName(), table.getTableName());
        }
    }

    private boolean setWriteIdForAcidDdl() throws SemanticException, LockException {
        boolean hasAcidDdl;
        DDLDesc.DDLDescWithWriteId acidDdlDesc = this.driverContext.getPlan().getAcidDdlDesc();
        boolean bl = hasAcidDdl = acidDdlDesc != null && acidDdlDesc.mayNeedWriteId();
        if (hasAcidDdl) {
            String fqTableName = acidDdlDesc.getFullTableName();
            TableName tableName = HiveTableName.of(fqTableName);
            long writeId = this.driverContext.getTxnManager().getTableWriteId(tableName.getDb(), tableName.getTable());
            acidDdlDesc.setWriteId(writeId);
        }
        return hasAcidDdl;
    }

    private void acquireLocksInternal() throws CommandProcessorException, LockException {
        String userFromUGI = DriverUtils.getUserFromUGI(this.driverContext);
        this.driverContext.getTxnManager().acquireLocks(this.driverContext.getPlan(), this.context, userFromUGI, this.driverState);
        List<HiveLock> locks = this.context.getHiveLocks();
        LOG.info("Operation {} obtained {} locks", (Object)this.driverContext.getPlan().getOperation(), (Object)(locks == null ? 0 : locks.size()));
        if (this.driverContext.getTxnManager().recordSnapshot(this.driverContext.getPlan()) && !this.driverContext.isValidTxnListsGenerated()) {
            throw new IllegalStateException("Need to record valid WriteID list but there is no valid TxnID list (" + JavaUtils.txnIdToString((long)this.driverContext.getTxnManager().getCurrentTxnId()) + ", queryId: " + this.driverContext.getPlan().getQueryId() + ")");
        }
    }

    ValidTxnWriteIdList recordValidWriteIds() throws LockException {
        String txnString = this.driverContext.getConf().get("hive.txn.valid.txns");
        if (Strings.isNullOrEmpty((String)txnString)) {
            throw new IllegalStateException("calling recordValidWritsIdss() without initializing ValidTxnList " + JavaUtils.txnIdToString((long)this.driverContext.getTxnManager().getCurrentTxnId()));
        }
        ValidTxnWriteIdList txnWriteIds = this.getTxnWriteIds(txnString);
        this.setValidWriteIds(txnWriteIds);
        LOG.debug("Encoding valid txn write ids info {} txnid: {}", (Object)txnWriteIds.toString(), (Object)this.driverContext.getTxnManager().getCurrentTxnId());
        return txnWriteIds;
    }

    private ValidTxnWriteIdList getTxnWriteIds(String txnString) throws LockException {
        List<String> txnTables = this.getTransactionalTables(this.getTables(true, true));
        ValidTxnWriteIdList txnWriteIds = null;
        if (this.driverContext.getCompactionWriteIds() != null) {
            if (txnTables.size() != 1) {
                throw new LockException("Unexpected tables in compaction: " + txnTables);
            }
            txnWriteIds = new ValidTxnWriteIdList(Long.valueOf(this.driverContext.getCompactorTxnId()));
            txnWriteIds.addTableValidWriteIdList(this.driverContext.getCompactionWriteIds());
        } else {
            txnWriteIds = this.driverContext.getTxnManager().getValidWriteIds(txnTables, txnString);
        }
        if (this.driverContext.getTxnType() == TxnType.READ_ONLY && !this.getTables(false, true).isEmpty()) {
            throw new IllegalStateException(String.format("Inferred transaction type '%s' doesn't conform to the actual query string '%s'", this.driverContext.getTxnType(), this.driverContext.getQueryState().getQueryString()));
        }
        return txnWriteIds;
    }

    private void setValidWriteIds(ValidTxnWriteIdList txnWriteIds) {
        Operator<?> source;
        this.driverContext.getConf().set("hive.txn.tables.valid.writeids", txnWriteIds.toString());
        if (this.driverContext.getPlan().getFetchTask() != null && (source = ((FetchWork)this.driverContext.getPlan().getFetchTask().getWork()).getSource()) instanceof TableScanOperator) {
            TableScanOperator tsOp = (TableScanOperator)source;
            String fullTableName = AcidUtils.getFullTableName(((TableScanDesc)tsOp.getConf()).getDatabaseName(), ((TableScanDesc)tsOp.getConf()).getTableName());
            ValidWriteIdList writeIdList = txnWriteIds.getTableValidWriteIdList(fullTableName);
            if (((TableScanDesc)tsOp.getConf()).isTranscationalTable() && writeIdList == null) {
                throw new IllegalStateException(String.format("ACID table: %s is missing from the ValidWriteIdList config: %s", fullTableName, txnWriteIds.toString()));
            }
            if (writeIdList != null) {
                this.driverContext.getPlan().getFetchTask().setValidWriteIdList(writeIdList.toString());
            }
        }
    }

    boolean isValidTxnListState() throws LockException {
        String txnString = this.driverContext.getConf().get("hive.txn.valid.txns");
        if (txnString == null) {
            return true;
        }
        Set<String> nonSharedLockedTables = this.getNonSharedLockedTables();
        if (nonSharedLockedTables.isEmpty()) {
            return true;
        }
        String txnWriteIdListString = this.driverContext.getConf().get("hive.txn.tables.valid.writeids");
        if (Strings.isNullOrEmpty((String)txnWriteIdListString)) {
            return true;
        }
        long txnId = this.driverContext.getTxnManager().getLatestTxnIdInConflict();
        if (txnId <= 0L) {
            return true;
        }
        if (txnId > this.driverContext.getTxnManager().getCurrentTxnId()) {
            this.driverContext.setOutdatedTxn(true);
        }
        return false;
    }

    private Set<String> getNonSharedLockedTables() {
        if (CollectionUtils.isEmpty(this.context.getHiveLocks())) {
            return Collections.emptySet();
        }
        HashSet<String> nonSharedLockedTables = new HashSet<String>();
        for (HiveLock lock : this.context.getHiveLocks()) {
            if (lock.mayContainComponents()) {
                for (LockComponent lockComponent : lock.getHiveLockComponents()) {
                    if (lockComponent.getType() != LockType.EXCLUSIVE && lockComponent.getType() != LockType.EXCL_WRITE || lockComponent.getTablename() == null || "__GLOBAL_LOCKS".equals(lockComponent.getDbname())) continue;
                    nonSharedLockedTables.add(TableName.getDbTable((String)lockComponent.getDbname(), (String)lockComponent.getTablename()));
                }
                continue;
            }
            if (lock.getHiveLockMode() != HiveLockMode.EXCLUSIVE && lock.getHiveLockMode() != HiveLockMode.SEMI_SHARED || lock.getHiveLockObject().getPaths().length != 2) continue;
            nonSharedLockedTables.add(TableName.getDbTable((String)lock.getHiveLockObject().getPaths()[0], (String)lock.getHiveLockObject().getPaths()[1]));
        }
        return nonSharedLockedTables;
    }

    private Map<String, Table> getTables(boolean inputNeeded, boolean outputNeeded) {
        HashMap<String, Table> tables = new HashMap<String, Table>();
        if (inputNeeded) {
            this.driverContext.getPlan().getInputs().forEach(input -> this.addTableFromEntity((Entity)input, (Map<String, Table>)tables));
        }
        if (outputNeeded) {
            this.driverContext.getPlan().getOutputs().forEach(output -> this.addTableFromEntity((Entity)output, (Map<String, Table>)tables));
        }
        return tables;
    }

    private void addTableFromEntity(Entity entity, Map<String, Table> tables) {
        Table table;
        switch (entity.getType()) {
            case TABLE: {
                table = entity.getTable();
                break;
            }
            case PARTITION: 
            case DUMMYPARTITION: {
                table = entity.getPartition().getTable();
                break;
            }
            default: {
                return;
            }
        }
        String fullTableName = AcidUtils.getFullTableName(table.getDbName(), table.getTableName());
        tables.put(fullTableName, table);
    }

    void rollback(CommandProcessorException cpe) throws CommandProcessorException {
        try {
            this.endTransactionAndCleanup(false);
        }
        catch (LockException e) {
            LOG.error("rollback() FAILED: " + cpe);
            DriverUtils.handleHiveException(this.driverContext, e, 12, "Additional info in hive.log at \"rollback() FAILED\"");
        }
    }

    void handleTransactionAfterExecution() throws CommandProcessorException {
        try {
            if (this.driverContext.getTxnManager().isImplicitTransactionOpen() || this.driverContext.getPlan().getOperation() == HiveOperation.COMMIT) {
                this.endTransactionAndCleanup(true);
            } else if (this.driverContext.getPlan().getOperation() == HiveOperation.ROLLBACK) {
                this.endTransactionAndCleanup(false);
            } else if (!this.driverContext.getTxnManager().isTxnOpen() && this.driverContext.getQueryState().getHiveOperation() == HiveOperation.REPLLOAD) {
                this.endTransactionAndCleanup(false);
            }
        }
        catch (LockException e) {
            DriverUtils.handleHiveException(this.driverContext, e, 12, null);
        }
    }

    private List<String> getTransactionalTables(Map<String, Table> tables) {
        return tables.entrySet().stream().filter(entry -> AcidUtils.isTransactionalTable((Table)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    void addHiveLocksFromContext() {
        this.hiveLocks.addAll(this.context.getHiveLocks());
    }

    void release() {
        this.release(!this.hiveLocks.isEmpty());
    }

    void destroy(String queryIdFromDriver) {
        boolean isTxnOpen = this.driverContext != null && this.driverContext.getTxnManager() != null && this.driverContext.getTxnManager().isTxnOpen() && org.apache.commons.lang3.StringUtils.equals((CharSequence)queryIdFromDriver, (CharSequence)this.driverContext.getTxnManager().getQueryid());
        this.release(!this.hiveLocks.isEmpty() || isTxnOpen);
    }

    private void release(boolean releaseLocks) {
        if (releaseLocks) {
            try {
                this.endTransactionAndCleanup(false);
            }
            catch (LockException e) {
                LOG.warn("Exception when releasing locking in destroy: " + e.getMessage());
            }
        }
        ShutdownHookManager.removeShutdownHook((Runnable)this.txnRollbackRunner);
    }

    void endTransactionAndCleanup(boolean commit) throws LockException {
        this.endTransactionAndCleanup(commit, this.driverContext.getTxnManager());
        ShutdownHookManager.removeShutdownHook((Runnable)this.txnRollbackRunner);
        this.txnRollbackRunner = null;
    }

    void endTransactionAndCleanup(boolean commit, HiveTxnManager txnManager) throws LockException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(CLASS_NAME, "releaseLocks");
        this.driverContext.getConf().unset("hive.txn.valid.txns");
        this.driverContext.getConf().unset("hive.txn.tables.valid.writeids");
        if (!DriverUtils.checkConcurrency(this.driverContext)) {
            return;
        }
        if (txnManager.isTxnOpen()) {
            this.commitOrRollback(commit, txnManager);
        } else {
            this.releaseLocks(txnManager, this.hiveLocks);
        }
        this.hiveLocks.clear();
        if (this.context != null) {
            this.context.setHiveLocks(null);
        }
        perfLogger.perfLogEnd(CLASS_NAME, "releaseLocks");
    }

    private void commitOrRollback(boolean commit, HiveTxnManager txnManager) throws LockException {
        if (commit) {
            if (this.driverContext.getConf().getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && this.driverContext.getConf().getBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN)) {
                txnManager.rollbackTxn();
            } else {
                txnManager.commitTxn();
            }
        } else {
            txnManager.rollbackTxn();
        }
    }

    private void releaseLocks(HiveTxnManager txnManager, List<HiveLock> hiveLocks) throws LockException {
        if (this.context != null && this.context.getHiveLocks() != null) {
            hiveLocks.addAll(this.context.getHiveLocks());
        }
        txnManager.releaseLocks(hiveLocks);
    }
}

