/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class DriverState {
    private static ThreadLocal<DriverState> tlInstance = new ThreadLocal<DriverState>(){

        @Override
        protected DriverState initialValue() {
            return new DriverState();
        }
    };
    private final ReentrantLock stateLock = new ReentrantLock();
    private final AtomicBoolean aborted = new AtomicBoolean();
    private State driverState = State.INITIALIZED;

    public static void setDriverState(DriverState state) {
        tlInstance.set(state);
    }

    public static DriverState getDriverState() {
        return tlInstance.get();
    }

    public static void removeDriverState() {
        tlInstance.remove();
    }

    public void lock() {
        this.stateLock.lock();
    }

    public void unlock() {
        this.stateLock.unlock();
    }

    public boolean isAborted() {
        return this.aborted.get();
    }

    public void abort() {
        this.aborted.set(true);
    }

    public void compiling() {
        this.driverState = State.COMPILING;
    }

    public void compilingWithLocking() {
        this.lock();
        try {
            this.driverState = State.COMPILING;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isCompiling() {
        return this.driverState == State.COMPILING;
    }

    public void compilationInterruptedWithLocking(boolean deferClose) {
        this.lock();
        try {
            this.driverState = deferClose ? State.EXECUTING : State.ERROR;
        }
        finally {
            this.unlock();
        }
    }

    public void compilationFinishedWithLocking(boolean wasError) {
        this.lock();
        try {
            this.driverState = wasError ? State.ERROR : State.COMPILED;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isCompiled() {
        return this.driverState == State.COMPILED;
    }

    public void executing() {
        this.driverState = State.EXECUTING;
    }

    public boolean isExecuting() {
        return this.driverState == State.EXECUTING;
    }

    public void executionFinishedWithLocking(boolean wasError) {
        this.lock();
        try {
            this.driverState = wasError ? State.ERROR : State.EXECUTED;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isExecuted() {
        return this.driverState == State.EXECUTED;
    }

    public void closed() {
        this.driverState = State.CLOSED;
    }

    public boolean isClosed() {
        return this.driverState == State.CLOSED;
    }

    public void descroyed() {
        this.driverState = State.DESTROYED;
    }

    public boolean isDestroyed() {
        return this.driverState == State.DESTROYED;
    }

    public void error() {
        this.driverState = State.ERROR;
    }

    public boolean isError() {
        return this.driverState == State.ERROR;
    }

    public String toString() {
        return String.format("%s(aborted:%s)", new Object[]{this.driverState, this.aborted.get()});
    }

    private static enum State {
        INITIALIZED,
        COMPILING,
        COMPILED,
        EXECUTING,
        EXECUTED,
        CLOSED,
        DESTROYED,
        ERROR;

    }
}

