/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import com.google.common.base.Strings;
import java.util.ArrayList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.reexec.IReExecutionPlugin;
import org.apache.hadoop.hive.ql.reexec.ReExecDriver;
import org.apache.hadoop.hive.ql.reexec.ReExecuteLostAMQueryPlugin;
import org.apache.hadoop.hive.ql.reexec.ReExecutionDagSubmitPlugin;
import org.apache.hadoop.hive.ql.reexec.ReExecutionOverlayPlugin;
import org.apache.hadoop.hive.ql.reexec.ReOptimizePlugin;

public final class DriverFactory {
    private DriverFactory() {
        throw new UnsupportedOperationException("DriverFactory should not be instantiated!");
    }

    public static IDriver newDriver(HiveConf conf) {
        return DriverFactory.newDriver(DriverFactory.getNewQueryState(conf), null);
    }

    public static IDriver newDriver(QueryState queryState, QueryInfo queryInfo) {
        boolean enabled = queryState.getConf().getBoolVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_ENABLED);
        if (!enabled) {
            return new Driver(queryState, queryInfo);
        }
        String strategies = queryState.getConf().getVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES);
        strategies = Strings.nullToEmpty((String)strategies).trim().toLowerCase();
        ArrayList<IReExecutionPlugin> plugins = new ArrayList<IReExecutionPlugin>();
        for (String string : strategies.split(",")) {
            if (string.trim().isEmpty()) continue;
            plugins.add(DriverFactory.buildReExecPlugin(string));
        }
        return new ReExecDriver(queryState, queryInfo, plugins);
    }

    private static IReExecutionPlugin buildReExecPlugin(String name) throws RuntimeException {
        if ("overlay".equals(name)) {
            return new ReExecutionOverlayPlugin();
        }
        if ("reoptimize".equals(name)) {
            return new ReOptimizePlugin();
        }
        if ("reexecute_lost_am".equals(name)) {
            return new ReExecuteLostAMQueryPlugin();
        }
        if (name.equals("dagsubmit")) {
            return new ReExecutionDagSubmitPlugin();
        }
        throw new RuntimeException("Unknown re-execution plugin: " + name + " (" + HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES.varname + ")");
    }

    public static QueryState getNewQueryState(HiveConf conf) {
        return new QueryState.Builder().withGenerateNewQueryId(true).withHiveConf(conf).build();
    }
}

