/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SomethingBinderAgainstBind;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlObjectBuilder;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;
import org.skife.jdbi.v2.sqlobject.mixins.CloseMe;

public class TestVariousOddities {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testAttach() throws Exception {
        Spiffy s = (Spiffy)SqlObjectBuilder.attach((Handle)this.handle, Spiffy.class);
        s.insert(new Something(14, "Tom"));
        Something tom = s.byId(14L);
        Assert.assertEquals((Object)"Tom", (Object)tom.getName());
    }

    @Test
    public void testRegisteredMappersWork() throws Exception {
    }

    @Test
    public void testEquals() {
        Spiffy s1 = (Spiffy)SqlObjectBuilder.attach((Handle)this.handle, Spiffy.class);
        Spiffy s2 = (Spiffy)SqlObjectBuilder.attach((Handle)this.handle, Spiffy.class);
        Assert.assertEquals((Object)s1, (Object)s1);
        Assert.assertNotSame((Object)s1, (Object)s2);
        Assert.assertFalse((boolean)s1.equals(s2));
    }

    @Test
    public void testToString() {
        Spiffy s1 = (Spiffy)SqlObjectBuilder.attach((Handle)this.handle, Spiffy.class);
        Spiffy s2 = (Spiffy)SqlObjectBuilder.attach((Handle)this.handle, Spiffy.class);
        Assert.assertNotNull((Object)s1.toString());
        Assert.assertNotNull((Object)s2.toString());
        Assert.assertTrue((s1.toString() != s2.toString() ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode() {
        Spiffy s1 = (Spiffy)SqlObjectBuilder.attach((Handle)this.handle, Spiffy.class);
        Spiffy s2 = (Spiffy)SqlObjectBuilder.attach((Handle)this.handle, Spiffy.class);
        Assert.assertFalse((0 == s1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((0 == s2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((s1.hashCode() != s2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentHashCode() throws ExecutionException, InterruptedException {
        Callable<SpiffyConcurrent> callable = new Callable<SpiffyConcurrent>(){

            @Override
            public SpiffyConcurrent call() throws Exception {
                return (SpiffyConcurrent)SqlObjectBuilder.attach((Handle)TestVariousOddities.this.handle, SpiffyConcurrent.class);
            }
        };
        ExecutorService pool = Executors.newFixedThreadPool(2);
        Future<SpiffyConcurrent> f1 = pool.submit(callable);
        Future<SpiffyConcurrent> f2 = pool.submit(callable);
        SpiffyConcurrent s1 = f1.get();
        SpiffyConcurrent s2 = f2.get();
        Assert.assertFalse((0 == s1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((0 == s2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((s1.hashCode() != s2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testNullQueryReturn() {
        try {
            SqlObjectBuilder.attach((Handle)this.handle, SpiffyBoom.class);
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"Method org.skife.jdbi.v2.sqlobject.TestVariousOddities$SpiffyBoom#returnNothing is annotated as if it should return a value, but the method is void.", (Object)e.getMessage());
            return;
        }
        Assert.fail();
    }

    public static interface SpiffyConcurrent {
    }

    public static interface SpiffyBoom
    extends CloseMe {
        @SqlQuery(value="SELECT 1")
        public void returnNothing();
    }

    public static interface Spiffy
    extends CloseMe {
        @SqlQuery(value="select id, name from something where id = :id")
        @Mapper(value=SomethingMapper.class)
        public Something byId(@Bind(value="id") long var1);

        @SqlUpdate(value="insert into something (id, name) values (:it.id, :it.name)")
        public void insert(@Bind(value="it", binder=SomethingBinderAgainstBind.class) Something var1);
    }
}

