/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlObjectBuilder;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;
import org.skife.jdbi.v2.sqlobject.mixins.CloseMe;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TestReturningQuery {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:" + UUID.randomUUID());
        this.dbi = new DBI((DataSource)ds);
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testWithRegisteredMapper() throws Exception {
        this.handle.execute("insert into something (id, name) values (7, 'Tim')", new Object[0]);
        this.dbi.registerMapper((ResultSetMapper)new SomethingMapper());
        Spiffy spiffy = (Spiffy)SqlObjectBuilder.open((IDBI)this.dbi, Spiffy.class);
        Something s = (Something)spiffy.findById(7).first();
        Assert.assertEquals((Object)"Tim", (Object)s.getName());
    }

    @Test
    public void testWithExplicitMapper() throws Exception {
        this.handle.execute("insert into something (id, name) values (7, 'Tim')", new Object[0]);
        Spiffy2 spiffy = (Spiffy2)SqlObjectBuilder.open((IDBI)this.dbi, Spiffy2.class);
        Something s = (Something)spiffy.findByIdWithExplicitMapper(7).first();
        Assert.assertEquals((Object)"Tim", (Object)s.getName());
    }

    public static interface Spiffy2
    extends CloseMe {
        @SqlQuery(value="select id, name from something where id = :id")
        @Mapper(value=SomethingMapper.class)
        public Query<Something> findByIdWithExplicitMapper(@Bind(value="id") int var1);
    }

    public static interface Spiffy
    extends CloseMe {
        @SqlQuery(value="select id, name from something where id = :id")
        public Query<Something> findById(@Bind(value="id") int var1);
    }
}

