/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcConnectionPool;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.GetGeneratedKeys;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.mixins.CloseMe;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class TestGetGeneratedKeys {
    private JdbcConnectionPool ds;
    private DBI dbi;

    @Before
    public void setUp() throws Exception {
        this.ds = JdbcConnectionPool.create((String)("jdbc:h2:mem:" + UUID.randomUUID()), (String)"username", (String)"password");
        this.dbi = new DBI((DataSource)this.ds);
        this.dbi.withHandle((HandleCallback)new HandleCallback<Object>(){

            public Object withHandle(Handle handle) throws Exception {
                handle.execute("create table something (id identity primary key, name varchar(32))", new Object[0]);
                return null;
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        this.ds.dispose();
    }

    @Test
    public void testFoo() throws Exception {
        DAO dao = (DAO)this.dbi.open(DAO.class);
        long brian_id = dao.insert("Brian");
        long keith_id = dao.insert("Keith");
        Assert.assertThat((Object)dao.findNameById(brian_id), (Matcher)CoreMatchers.equalTo((Object)"Brian"));
        Assert.assertThat((Object)dao.findNameById(keith_id), (Matcher)CoreMatchers.equalTo((Object)"Keith"));
        dao.close();
    }

    public static interface DAO
    extends CloseMe {
        @SqlUpdate(value="insert into something (name) values (:it)")
        @GetGeneratedKeys
        public long insert(@Bind String var1);

        @SqlQuery(value="select name from something where id = :it")
        public String findNameById(@Bind long var1);
    }
}

