/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class TestConcurrentUpdatingQuery {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:" + UUID.randomUUID());
        this.dbi = new DBI((DataSource)ds);
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testConcurrentUpdateableResultSet() throws Exception {
        this.handle.execute("insert into something (id, name) values (7, 'Tim')", new Object[0]);
        ((Query)this.handle.createQuery("select id, name from something where id = :id").bind("id", 7)).concurrentUpdatable().map((ResultSetMapper)new ResultSetMapper<Object>(){

            public Object map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                r.updateString("name", "Tom");
                r.updateRow();
                return null;
            }
        }).list();
        String name = (String)((Query)this.handle.createQuery("select name from something where id = :id").bind("id", 7)).map((ResultSetMapper)StringMapper.FIRST).first();
        Assert.assertEquals((Object)"Tom", (Object)name);
    }
}

