/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.FixedValue;
import net.sf.cglib.proxy.NoOp;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.sqlobject.CGLIBDispatchBuilder;

public class TestCglibDispatchBuilder {
    @Test
    public void testEnhancer() throws Exception {
        CGLIBDispatchBuilder b = CGLIBDispatchBuilder.create().withDefault((Callback)NoOp.INSTANCE).addCallback(Base.class.getMethod("foo", new Class[0]), (Callback)new FixedValue(){

            public Object loadObject() throws Exception {
                return "hello";
            }
        });
        Enhancer e = new Enhancer();
        e.setSuperclass(Base.class);
        e.setCallbackFilter(b.getFilter());
        e.setCallbacks(b.getCallbacks());
        Base base = (Base)e.create();
        Assert.assertThat((Object)base.foo(), (Matcher)CoreMatchers.equalTo((Object)"hello"));
        Assert.assertThat((Object)base.bar(), (Matcher)CoreMatchers.equalTo((Object)"world"));
    }

    @Test
    public void testFactory() throws Exception {
        CGLIBDispatchBuilder b = CGLIBDispatchBuilder.create().withDefault((Callback)NoOp.INSTANCE).addCallback(Base.class.getMethod("foo", new Class[0]), (Callback)new FixedValue(){

            public Object loadObject() throws Exception {
                return "hello";
            }
        });
        Enhancer e = new Enhancer();
        e.setSuperclass(Base.class);
        e.setCallbackFilter(b.getFilter());
        e.setCallbacks(b.getCallbacks());
        Factory factory = (Factory)e.create();
        Base base = (Base)factory.newInstance(b.getCallbacks());
        Assert.assertThat((Object)base.foo(), (Matcher)CoreMatchers.equalTo((Object)"hello"));
        Assert.assertThat((Object)base.bar(), (Matcher)CoreMatchers.equalTo((Object)"world"));
    }

    @Test
    public void testFactoryWithDifferentBuilder() throws Exception {
        CGLIBDispatchBuilder b = CGLIBDispatchBuilder.create().withDefault((Callback)NoOp.INSTANCE).addCallback(Base.class.getMethod("foo", new Class[0]), (Callback)new FixedValue(){

            public Object loadObject() throws Exception {
                return "hello";
            }
        });
        Enhancer e = new Enhancer();
        e.setSuperclass(Base.class);
        e.setCallbackFilter(b.getFilter());
        e.setCallbacks(b.getCallbacks());
        Factory factory = (Factory)e.create();
        CGLIBDispatchBuilder b2 = CGLIBDispatchBuilder.create().withDefault((Callback)NoOp.INSTANCE).addCallback(Base.class.getMethod("foo", new Class[0]), (Callback)new FixedValue(){

            public Object loadObject() throws Exception {
                return "fred";
            }
        });
        Base base = (Base)factory.newInstance(b2.getCallbacks());
        Assert.assertThat((Object)base.foo(), (Matcher)CoreMatchers.equalTo((Object)"fred"));
        Assert.assertThat((Object)base.bar(), (Matcher)CoreMatchers.equalTo((Object)"world"));
    }

    public static abstract class Base {
        public abstract String foo();

        public String bar() {
            return "world";
        }
    }
}

