/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.docs;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.ContainerBuilder;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.logging.PrintStreamLog;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterContainerMapper;
import org.skife.jdbi.v2.sqlobject.stringtemplate.UseStringTemplate3StatementLocator;
import org.skife.jdbi.v2.tweak.ContainerFactory;
import org.skife.jdbi.v2.tweak.SQLLog;
import org.skife.jdbi.v2.unstable.BindIn;

public class TestInClauseExpansion {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        this.dbi.setSQLLog((SQLLog)new PrintStreamLog(System.out));
        this.handle = this.dbi.open();
        this.handle.execute("create table something( id integer primary key, name varchar(100) )", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.close();
    }

    @Test
    public void testInClauseExpansion() throws Exception {
        this.handle.execute("insert into something (name, id) values ('Brian', 1), ('Jeff', 2), ('Tom', 3)", new Object[0]);
        DAO dao = (DAO)this.handle.attach(DAO.class);
        Assert.assertThat(dao.findIdsForNames(Arrays.asList(1, 2)), (Matcher)CoreMatchers.equalTo((Object)ImmutableSet.of((Object)"Brian", (Object)"Jeff")));
    }

    public static class ImmutableSetContainerFactory
    implements ContainerFactory<ImmutableSet> {
        public boolean accepts(Class<?> type) {
            return ImmutableSet.class.isAssignableFrom(type);
        }

        public ContainerBuilder<ImmutableSet> newContainerBuilderFor(Class<?> type) {
            return new ContainerBuilder<ImmutableSet>(){
                final ImmutableSet.Builder<Object> builder = ImmutableSet.builder();

                public ContainerBuilder<ImmutableSet> add(Object it) {
                    this.builder.add(it);
                    return this;
                }

                public ImmutableSet build() {
                    return this.builder.build();
                }
            };
        }
    }

    @UseStringTemplate3StatementLocator
    @RegisterContainerMapper(value={ImmutableSetContainerFactory.class})
    public static interface DAO {
        @SqlQuery
        public ImmutableSet<String> findIdsForNames(@BindIn(value="names") List<Integer> var1);
    }
}

