/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.docs;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcConnectionPool;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.ExtraMatchers;
import org.skife.jdbi.v2.Folder2;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlBatch;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.BatchChunkSize;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class TestDocumentation {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testFiveMinuteFluentApi() throws Exception {
        JdbcConnectionPool ds = JdbcConnectionPool.create((String)("jdbc:h2:mem:" + UUID.randomUUID()), (String)"username", (String)"password");
        DBI dbi = new DBI((DataSource)ds);
        Handle h = dbi.open();
        h.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
        h.execute("insert into something (id, name) values (?, ?)", new Object[]{1, "Brian"});
        String name = (String)((Query)h.createQuery("select name from something where id = :id").bind("id", 1)).map((ResultSetMapper)StringMapper.FIRST).first();
        Assert.assertThat((Object)name, (Matcher)CoreMatchers.equalTo((Object)"Brian"));
        h.close();
        ds.dispose();
    }

    @Test
    public void testFiveMinuteSqlObjectExample() throws Exception {
        DBI dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        MyDAO dao = (MyDAO)dbi.open(MyDAO.class);
        dao.createSomethingTable();
        dao.insert(2, "Aaron");
        String name = dao.findNameById(2);
        Assert.assertThat((Object)name, (Matcher)CoreMatchers.equalTo((Object)"Aaron"));
        dao.close();
    }

    @Test
    public void testObtainHandleViaOpen() throws Exception {
        DBI dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        Handle handle = dbi.open();
        handle.close();
    }

    @Test
    public void testObtainHandleInCallback() throws Exception {
        DBI dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                handle.execute("create table silly (id int)", new Object[0]);
                return null;
            }
        });
    }

    @Test
    public void testExecuteSomeStatements() throws Exception {
        DBI dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        Handle h = dbi.open();
        h.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
        h.execute("insert into something (id, name) values (?, ?)", new Object[]{3, "Patrick"});
        List rs = h.select("select id, name from something", new Object[0]);
        Assert.assertThat((Object)rs.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Map row = (Map)rs.get(0);
        Assert.assertThat((Object)((Integer)row.get("id")), (Matcher)CoreMatchers.equalTo((Object)3));
        Assert.assertThat((Object)((String)row.get("name")), (Matcher)CoreMatchers.equalTo((Object)"Patrick"));
        h.close();
    }

    @Test
    public void testFluentUpdate() throws Exception {
        DBI dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        Handle h = dbi.open();
        h.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
        ((org.skife.jdbi.v2.Update)((org.skife.jdbi.v2.Update)h.createStatement("insert into something(id, name) values (:id, :name)").bind("id", 4)).bind("name", "Martin")).execute();
        h.close();
    }

    @Test
    public void testFold() throws Exception {
        DBI dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        Handle h = dbi.open();
        h.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
        h.execute("insert into something (id, name) values (7, 'Mark')", new Object[0]);
        h.execute("insert into something (id, name) values (8, 'Tatu')", new Object[0]);
        StringBuilder rs = (StringBuilder)h.createQuery("select name from something order by id").map((ResultSetMapper)StringMapper.FIRST).fold((Object)new StringBuilder(), (Folder2)new Folder2<StringBuilder>(){

            public StringBuilder fold(StringBuilder acc, ResultSet rs, StatementContext ctx) throws SQLException {
                acc.append(rs.getString(1)).append(", ");
                return acc;
            }
        });
        rs.delete(rs.length() - 2, rs.length());
        Assert.assertThat((Object)rs.toString(), (Matcher)CoreMatchers.equalTo((Object)"Mark, Tatu"));
        h.close();
    }

    @Test
    public void testMappingExampleChainedIterator2() throws Exception {
        DBI dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        Handle h = dbi.open();
        h.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
        h.execute("insert into something (id, name) values (1, 'Brian')", new Object[0]);
        h.execute("insert into something (id, name) values (2, 'Keith')", new Object[0]);
        ResultIterator rs = h.createQuery("select name from something order by id").map((ResultSetMapper)StringMapper.FIRST).iterator();
        Assert.assertThat(rs.next(), (Matcher)CoreMatchers.equalTo((Object)"Brian"));
        Assert.assertThat(rs.next(), (Matcher)CoreMatchers.equalTo((Object)"Keith"));
        Assert.assertThat((Object)rs.hasNext(), (Matcher)CoreMatchers.equalTo((Object)false));
        h.close();
    }

    @Test
    public void testMappingExampleChainedIterator3() throws Exception {
        DBI dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        Handle h = dbi.open();
        h.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
        h.execute("insert into something (id, name) values (1, 'Brian')", new Object[0]);
        h.execute("insert into something (id, name) values (2, 'Keith')", new Object[0]);
        for (String name : h.createQuery("select name from something order by id").map((ResultSetMapper)StringMapper.FIRST)) {
            Assert.assertThat((Object)name, ExtraMatchers.equalsOneOf("Brian", "Keith"));
        }
        h.close();
    }

    @Test
    public void testAttachToObject() throws Exception {
        DBI dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        Handle h = dbi.open();
        MyDAO dao = (MyDAO)h.attach(MyDAO.class);
        h.close();
    }

    @Test
    public void testOnDemandDao() throws Exception {
        DBI dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        MyDAO dao = (MyDAO)dbi.onDemand(MyDAO.class);
    }

    @Test
    public void testSomeQueriesWorkCorrectly() throws Exception {
        DBI dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        Handle h = dbi.open();
        h.execute("create table something (id int primary key, name varchar(32))", new Object[0]);
        ((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)h.prepareBatch("insert into something (id, name) values (:id, :name)").add().bind("id", 1)).bind("name", "Brian")).next().bind("id", 2)).bind("name", "Robert")).next().bind("id", 3)).bind("name", "Patrick")).next().bind("id", 4)).bind("name", "Maniax")).submit().execute();
        SomeQueries sq = (SomeQueries)h.attach(SomeQueries.class);
        Assert.assertThat((Object)sq.findName(2), (Matcher)CoreMatchers.equalTo((Object)"Robert"));
        Assert.assertThat(sq.findNamesBetween(1, 4), (Matcher)CoreMatchers.equalTo(Arrays.asList("Robert", "Patrick")));
        Iterator<String> names = sq.findAllNames();
        Assert.assertThat((Object)names.next(), (Matcher)CoreMatchers.equalTo((Object)"Brian"));
        Assert.assertThat((Object)names.next(), (Matcher)CoreMatchers.equalTo((Object)"Robert"));
        Assert.assertThat((Object)names.next(), (Matcher)CoreMatchers.equalTo((Object)"Patrick"));
        Assert.assertThat((Object)names.next(), (Matcher)CoreMatchers.equalTo((Object)"Maniax"));
        Assert.assertThat((Object)names.hasNext(), (Matcher)CoreMatchers.equalTo((Object)false));
        h.close();
    }

    @Test
    public void testAnotherCoupleInterfaces() throws Exception {
        DBI dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        Handle h = dbi.open();
        h.execute("create table something (id int primary key, name varchar(32))", new Object[0]);
        ((BatchInserter)h.attach(BatchInserter.class)).insert(new Something(1, "Brian"), new Something(3, "Patrick"), new Something(2, "Robert"));
        AnotherQuery aq = (AnotherQuery)h.attach(AnotherQuery.class);
        YetAnotherQuery yaq = (YetAnotherQuery)h.attach(YetAnotherQuery.class);
        Assert.assertThat((Object)yaq.findById(3), (Matcher)CoreMatchers.equalTo((Object)new Something(3, "Patrick")));
        Assert.assertThat((Object)aq.findById(2), (Matcher)CoreMatchers.equalTo((Object)new Something(2, "Robert")));
        h.close();
    }

    @Test
    public void testFoo() throws Exception {
        DBI dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        Handle h = dbi.open();
        h.execute("create table something (id int primary key, name varchar(32))", new Object[0]);
        ((BatchInserter)h.attach(BatchInserter.class)).insert(new Something(1, "Brian"), new Something(3, "Patrick"), new Something(2, "Robert"));
        QueryReturningQuery qrq = (QueryReturningQuery)h.attach(QueryReturningQuery.class);
        Query<String> q = qrq.findById(1);
        q.setMaxFieldSize(100);
        Assert.assertThat((Object)q.first(), (Matcher)CoreMatchers.equalTo((Object)"Brian"));
        h.close();
    }

    @Test
    public void testUpdateAPI() throws Exception {
        DBI dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        Handle h = dbi.open();
        Update u = (Update)h.attach(Update.class);
        u.createSomethingTable();
        u.insert(17, "David");
        u.update(new Something(17, "David P."));
        String name = (String)h.createQuery("select name from something where id = 17").map((ResultSetMapper)StringMapper.FIRST).first();
        Assert.assertThat((Object)name, (Matcher)CoreMatchers.equalTo((Object)"David P."));
        h.close();
    }

    @Test
    public void testBatchExample() throws Exception {
        DBI dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        Handle h = dbi.open();
        BatchExample b = (BatchExample)h.attach(BatchExample.class);
        b.createSomethingTable();
        List<Integer> ids = Arrays.asList(1, 2, 3, 4, 5);
        Iterator<String> first_names = Arrays.asList("Tip", "Jane", "Brian", "Keith", "Eric").iterator();
        b.insertFamily(ids, first_names, "McCallister");
        Assert.assertThat((Object)b.findNameById(1), (Matcher)CoreMatchers.equalTo((Object)"Tip McCallister"));
        Assert.assertThat((Object)b.findNameById(2), (Matcher)CoreMatchers.equalTo((Object)"Jane McCallister"));
        Assert.assertThat((Object)b.findNameById(3), (Matcher)CoreMatchers.equalTo((Object)"Brian McCallister"));
        Assert.assertThat((Object)b.findNameById(4), (Matcher)CoreMatchers.equalTo((Object)"Keith McCallister"));
        Assert.assertThat((Object)b.findNameById(5), (Matcher)CoreMatchers.equalTo((Object)"Eric McCallister"));
        h.close();
    }

    public static interface BindBeanExample {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@BindBean Something var1);

        @SqlUpdate(value="update something set name = :s.name where id = :s.id")
        public void update(@BindBean(value="s") Something var1);
    }

    public static interface BindExamples {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlUpdate(value="delete from something where name = :it")
        public void deleteByName(@Bind String var1);
    }

    public static interface ChunkedBatchExample {
        @SqlBatch(value="insert into something (id, name) values (:id, :first || ' ' || :last)")
        @BatchChunkSize(value=2)
        public void insertFamily(@Bind(value="id") List<Integer> var1, @Bind(value="first") Iterator<String> var2, @Bind(value="last") String var3);

        @SqlUpdate(value="create table something(id int primary key, name varchar(32))")
        public void createSomethingTable();

        @SqlQuery(value="select name from something where id = :it")
        public String findNameById(@Bind int var1);
    }

    public static interface BatchExample {
        @SqlBatch(value="insert into something (id, name) values (:id, :first || ' ' || :last)")
        public void insertFamily(@Bind(value="id") List<Integer> var1, @Bind(value="first") Iterator<String> var2, @Bind(value="last") String var3);

        @SqlUpdate(value="create table something(id int primary key, name varchar(32))")
        public void createSomethingTable();

        @SqlQuery(value="select name from something where id = :it")
        public String findNameById(@Bind int var1);
    }

    public static interface Update {
        @SqlUpdate(value="create table something (id integer primary key, name varchar(32))")
        public void createSomethingTable();

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public int insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlUpdate(value="update something set name = :name where id = :id")
        public int update(@BindBean Something var1);
    }

    public static interface QueryReturningQuery {
        @SqlQuery(value="select name from something where id = :id")
        public Query<String> findById(@Bind(value="id") int var1);
    }

    public static interface BatchInserter {
        @SqlBatch(value="insert into something (id, name) values (:id, :name)")
        public void insert(Something ... var1);
    }

    public static interface YetAnotherQuery {
        @SqlQuery(value="select id, name from something where id = :id")
        @Mapper(value=SomethingMapper.class)
        public Something findById(@Bind(value="id") int var1);
    }

    @RegisterMapper(value={SomethingMapper.class})
    public static interface AnotherQuery {
        @SqlQuery(value="select id, name from something where id = :id")
        public Something findById(@Bind(value="id") int var1);
    }

    public static interface SomeQueries {
        @SqlQuery(value="select name from something where id = :id")
        public String findName(@Bind(value="id") int var1);

        @SqlQuery(value="select name from something where id > :from and id < :to order by id")
        public List<String> findNamesBetween(@Bind(value="from") int var1, @Bind(value="to") int var2);

        @SqlQuery(value="select name from something order by id")
        public Iterator<String> findAllNames();
    }

    public static interface MyDAO {
        @SqlUpdate(value="create table something (id int primary key, name varchar(100))")
        public void createSomethingTable();

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlQuery(value="select name from something where id = :id")
        public String findNameById(@Bind(value="id") int var1);

        public void close();
    }
}

