/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.exceptions.TransactionFailedException;
import org.skife.jdbi.v2.logging.Log4JLog;
import org.skife.jdbi.v2.logging.PrintStreamLog;
import org.skife.jdbi.v2.tweak.SQLLog;

public class TestSqlLogging
extends DBITestCase {
    private Handle h;
    private List<String> logged;
    private SQLLog log;
    private static final String linesep = System.getProperty("line.separator");

    @Override
    public void doSetUp() throws Exception {
        this.h = this.openHandle();
        this.logged = new ArrayList<String>();
        this.log = new SQLLog(){

            public void logBeginTransaction(Handle h) {
                TestSqlLogging.this.logged.add("begin");
            }

            public void logCommitTransaction(long time, Handle h) {
                TestSqlLogging.this.logged.add("commit");
            }

            public void logRollbackTransaction(long time, Handle h) {
                TestSqlLogging.this.logged.add("rollback");
            }

            public void logObtainHandle(long time, Handle h) {
                TestSqlLogging.this.logged.add("open");
            }

            public void logReleaseHandle(Handle h) {
                TestSqlLogging.this.logged.add("close");
            }

            public void logSQL(long time, String sql) {
                TestSqlLogging.this.logged.add(sql);
            }

            public void logPreparedBatch(long time, String sql, int count) {
                TestSqlLogging.this.logged.add(String.format("%d:%s", count, sql));
            }

            public SQLLog.BatchLogger logBatch() {
                return new SQLLog.BatchLogger(){

                    public void add(String sql) {
                        TestSqlLogging.this.logged.add(sql);
                    }

                    public void log(long time) {
                    }
                };
            }

            public void logCheckpointTransaction(Handle h, String name) {
                TestSqlLogging.this.logged.add(String.format("checkpoint %s created", name));
            }

            public void logReleaseCheckpointTransaction(Handle h, String name) {
                TestSqlLogging.this.logged.add(String.format("checkpoint %s released", name));
            }

            public void logRollbackToCheckpoint(long time, Handle h, String name) {
                TestSqlLogging.this.logged.add(String.format("checkpoint %s rolled back to", name));
            }
        };
        this.h.setSQLLog(this.log);
    }

    @Override
    public void doTearDown() throws Exception {
        if (this.h != null) {
            this.h.close();
        }
    }

    @Test
    public void testInsert() throws Exception {
        this.h.insert("insert into something (id, name) values (?, ?)", new Object[]{1, "Hello"});
        Assert.assertEquals((long)1L, (long)this.logged.size());
        Assert.assertEquals((Object)"insert into something (id, name) values (?, ?)", (Object)this.logged.get(0));
    }

    @Test
    public void testBatch() throws Exception {
        String sql1 = "insert into something (id, name) values (1, 'Eric')";
        String sql2 = "insert into something (id, name) values (2, 'Keith')";
        this.h.createBatch().add(sql1).add(sql2).execute();
        Assert.assertEquals((long)2L, (long)this.logged.size());
        Assert.assertEquals((Object)sql1, (Object)this.logged.get(0));
        Assert.assertEquals((Object)sql2, (Object)this.logged.get(1));
    }

    @Test
    public void testPreparedBatch() throws Exception {
        String sql = "insert into something (id, name) values (?, ?)";
        this.h.prepareBatch(sql).add(new Object[]{1, "Eric"}).add(new Object[]{2, "Keith"}).execute();
        Assert.assertEquals((long)1L, (long)this.logged.size());
        Assert.assertEquals((Object)String.format("%d:%s", 2, sql), (Object)this.logged.get(0));
    }

    @Test
    public void testLog4J() throws Exception {
        BasicConfigurator.configure((Appender)new AppenderSkeleton(){

            protected void append(LoggingEvent loggingEvent) {
                TestSqlLogging.this.logged.add(loggingEvent.getRenderedMessage());
            }

            public boolean requiresLayout() {
                return false;
            }

            public void close() {
            }
        });
        this.h.setSQLLog((SQLLog)new Log4JLog());
        Logger.getLogger((String)"org.skife.jdbi").setLevel(Level.DEBUG);
        String sql1 = "insert into something (id, name) values (1, 'Eric')";
        String sql2 = "insert into something (id, name) values (2, 'Keith')";
        this.h.createBatch().add(sql1).add(sql2).execute();
        Assert.assertEquals((long)1L, (long)this.logged.size());
        Assert.assertTrue((boolean)this.logged.get(0).matches("batch:\\[\\[insert into something \\(id, name\\) values \\(1, 'Eric'\\)\\], \\[insert into something \\(id, name\\) values \\(2, 'Keith'\\)\\]\\] took \\d+ millis"));
    }

    @Test
    public void testPrintStream() throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.h.setSQLLog((SQLLog)new PrintStreamLog(new PrintStream(bout)));
        String sql = "insert into something (id, name) values (?, ?)";
        this.h.insert(sql, new Object[]{1, "Brian"});
        Assert.assertTrue((boolean)new String(bout.toByteArray()).matches("statement:\\[insert into something \\(id, name\\) values \\(\\?, \\?\\)\\] took \\d+ millis" + linesep));
    }

    @Test
    public void testCloseLogged() throws Exception {
        this.h.close();
        Assert.assertTrue((boolean)this.logged.contains("close"));
    }

    @Test
    public void testLogBegin() throws Exception {
        this.h.begin();
        Assert.assertTrue((boolean)this.logged.contains("begin"));
        this.h.commit();
    }

    @Test
    public void testLogCommit() throws Exception {
        this.h.begin();
        this.h.commit();
        Assert.assertTrue((boolean)this.logged.contains("commit"));
    }

    @Test
    public void testLogBeginCommit() throws Exception {
        this.h.inTransaction((TransactionCallback)new TransactionCallback<Object>(){

            public Object inTransaction(Handle handle, TransactionStatus status) throws Exception {
                Assert.assertTrue((boolean)TestSqlLogging.this.logged.contains("begin"));
                return null;
            }
        });
        Assert.assertTrue((boolean)this.logged.contains("commit"));
    }

    @Test
    public void testLogBeginRollback() throws Exception {
        try {
            this.h.inTransaction((TransactionCallback)new TransactionCallback<Object>(){

                public Object inTransaction(Handle handle, TransactionStatus status) throws Exception {
                    Assert.assertTrue((boolean)TestSqlLogging.this.logged.contains("begin"));
                    throw new Exception();
                }
            });
            Assert.fail((String)"should have raised exception");
        }
        catch (TransactionFailedException e) {
            Assert.assertTrue((boolean)this.logged.contains("rollback"));
        }
    }

    @Test
    public void testLogRollback() throws Exception {
        this.h.begin();
        this.h.rollback();
        Assert.assertTrue((boolean)this.logged.contains("rollback"));
    }

    @Test
    public void testCheckpoint() throws Exception {
        this.h.begin();
        this.h.checkpoint("a");
        Assert.assertTrue((boolean)this.logged.contains("checkpoint a created"));
        this.h.rollback("a");
        Assert.assertTrue((boolean)this.logged.contains("checkpoint a rolled back to"));
        this.h.checkpoint("b");
        Assert.assertTrue((boolean)this.logged.contains("checkpoint b created"));
        this.h.release("b");
        Assert.assertTrue((boolean)this.logged.contains("checkpoint b released"));
        this.h.commit();
    }
}

