/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TestRegisteredMappers {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testRegisterInferredOnDBI() throws Exception {
        this.dbi.registerMapper((ResultSetMapper)new SomethingMapper());
        Something sam = (Something)this.dbi.withHandle((HandleCallback)new HandleCallback<Something>(){

            public Something withHandle(Handle handle) throws Exception {
                handle.insert("insert into something (id, name) values (18, 'Sam')", new Object[0]);
                return (Something)((Query)handle.createQuery("select id, name from something where id = :id").bind("id", 18)).mapTo(Something.class).first();
            }
        });
        Assert.assertEquals((Object)"Sam", (Object)sam.getName());
    }
}

