/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.skife.jdbi.v2.DerivedBean;
import org.skife.jdbi.v2.ReflectionBeanMapper;
import org.skife.jdbi.v2.SampleBean;
import org.skife.jdbi.v2.StatementContext;

@RunWith(value=EasyMockRunner.class)
public class ReflectionBeanMapperTest {
    @Mock
    ResultSet resultSet;
    @Mock
    ResultSetMetaData resultSetMetaData;
    @Mock
    StatementContext ctx;
    ReflectionBeanMapper<SampleBean> mapper = new ReflectionBeanMapper(SampleBean.class);

    @Test
    public void shouldSetValueOnPrivateField() throws Exception {
        EasyMock.expect((Object)this.resultSetMetaData.getColumnCount()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)this.resultSetMetaData.getColumnLabel(1)).andReturn((Object)"longField");
        EasyMock.replay((Object[])new Object[]{this.resultSetMetaData});
        EasyMock.expect((Object)this.resultSet.getMetaData()).andReturn((Object)this.resultSetMetaData);
        Long aLongVal = 100L;
        EasyMock.expect((Object)this.resultSet.getLong(1)).andReturn((Object)aLongVal);
        EasyMock.expect((Object)this.resultSet.wasNull()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.resultSet});
        SampleBean sampleBean = (SampleBean)this.mapper.map(0, this.resultSet, this.ctx);
        Assert.assertSame((Object)aLongVal, (Object)sampleBean.getLongField());
    }

    @Test
    public void shouldHandleEmptyResult() throws Exception {
        EasyMock.expect((Object)this.resultSetMetaData.getColumnCount()).andReturn((Object)0);
        EasyMock.replay((Object[])new Object[]{this.resultSetMetaData});
        EasyMock.expect((Object)this.resultSet.getMetaData()).andReturn((Object)this.resultSetMetaData);
        EasyMock.replay((Object[])new Object[]{this.resultSet});
        SampleBean sampleBean = (SampleBean)this.mapper.map(0, this.resultSet, this.ctx);
        Assert.assertNotNull((Object)sampleBean);
    }

    @Test
    public void shouldBeCaseInSensitiveOfColumnAndFieldNames() throws Exception {
        EasyMock.expect((Object)this.resultSetMetaData.getColumnCount()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)this.resultSetMetaData.getColumnLabel(1)).andReturn((Object)"LoNgfielD");
        EasyMock.replay((Object[])new Object[]{this.resultSetMetaData});
        EasyMock.expect((Object)this.resultSet.getMetaData()).andReturn((Object)this.resultSetMetaData);
        Long aLongVal = 100L;
        EasyMock.expect((Object)this.resultSet.getLong(1)).andReturn((Object)aLongVal);
        EasyMock.expect((Object)this.resultSet.wasNull()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.resultSet});
        SampleBean sampleBean = (SampleBean)this.mapper.map(0, this.resultSet, this.ctx);
        Assert.assertSame((Object)aLongVal, (Object)sampleBean.getLongField());
    }

    @Test
    public void shouldHandleNullValue() throws Exception {
        EasyMock.expect((Object)this.resultSetMetaData.getColumnCount()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)this.resultSetMetaData.getColumnLabel(1)).andReturn((Object)"LoNgfielD");
        EasyMock.replay((Object[])new Object[]{this.resultSetMetaData});
        EasyMock.expect((Object)this.resultSet.getMetaData()).andReturn((Object)this.resultSetMetaData);
        EasyMock.expect((Object)this.resultSet.getLong(1)).andReturn((Object)0L);
        EasyMock.expect((Object)this.resultSet.wasNull()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.resultSet});
        SampleBean sampleBean = (SampleBean)this.mapper.map(0, this.resultSet, this.ctx);
        Assert.assertNull((Object)sampleBean.getLongField());
    }

    @Test
    public void shouldSetValuesOnAllFieldAccessTypes() throws Exception {
        EasyMock.expect((Object)this.resultSetMetaData.getColumnCount()).andReturn((Object)4).anyTimes();
        EasyMock.expect((Object)this.resultSetMetaData.getColumnLabel(1)).andReturn((Object)"longField");
        EasyMock.expect((Object)this.resultSetMetaData.getColumnLabel(2)).andReturn((Object)"stringField");
        EasyMock.expect((Object)this.resultSetMetaData.getColumnLabel(3)).andReturn((Object)"intField");
        EasyMock.expect((Object)this.resultSetMetaData.getColumnLabel(4)).andReturn((Object)"bigDecimalField");
        EasyMock.replay((Object[])new Object[]{this.resultSetMetaData});
        EasyMock.expect((Object)this.resultSet.getMetaData()).andReturn((Object)this.resultSetMetaData);
        Long aLongVal = 100L;
        String aStringVal = "something";
        int aIntVal = 1;
        BigDecimal aBigDecimal = BigDecimal.TEN;
        EasyMock.expect((Object)this.resultSet.getLong(1)).andReturn((Object)aLongVal);
        EasyMock.expect((Object)this.resultSet.getString(2)).andReturn((Object)aStringVal);
        EasyMock.expect((Object)this.resultSet.getInt(3)).andReturn((Object)aIntVal);
        EasyMock.expect((Object)this.resultSet.getBigDecimal(4)).andReturn((Object)aBigDecimal);
        EasyMock.expect((Object)this.resultSet.wasNull()).andReturn((Object)false).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.resultSet});
        SampleBean sampleBean = (SampleBean)this.mapper.map(0, this.resultSet, this.ctx);
        Assert.assertSame((Object)aLongVal, (Object)sampleBean.getLongField());
        Assert.assertSame((Object)aBigDecimal, (Object)sampleBean.getBigDecimalField());
        Assert.assertSame((Object)aIntVal, (Object)sampleBean.getIntField());
        Assert.assertSame((Object)aStringVal, (Object)sampleBean.getStringField());
    }

    @Test
    public void shouldSetValuesInSuperClassFields() throws Exception {
        EasyMock.expect((Object)this.resultSetMetaData.getColumnCount()).andReturn((Object)2).anyTimes();
        EasyMock.expect((Object)this.resultSetMetaData.getColumnLabel(1)).andReturn((Object)"longField");
        EasyMock.expect((Object)this.resultSetMetaData.getColumnLabel(2)).andReturn((Object)"blongField");
        EasyMock.replay((Object[])new Object[]{this.resultSetMetaData});
        EasyMock.expect((Object)this.resultSet.getMetaData()).andReturn((Object)this.resultSetMetaData);
        Long aLongVal = 100L;
        Long bLongVal = 200L;
        EasyMock.expect((Object)this.resultSet.getLong(1)).andReturn((Object)aLongVal);
        EasyMock.expect((Object)this.resultSet.getLong(2)).andReturn((Object)bLongVal);
        EasyMock.expect((Object)this.resultSet.wasNull()).andReturn((Object)false).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.resultSet});
        ReflectionBeanMapper mapper = new ReflectionBeanMapper(DerivedBean.class);
        DerivedBean derivedBean = (DerivedBean)mapper.map(0, this.resultSet, this.ctx);
        Assert.assertEquals((Object)aLongVal, (Object)derivedBean.getLongField());
        Assert.assertEquals((Object)bLongVal, (Object)derivedBean.getBlongField());
    }
}

