/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.ws;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ws.AbstractBasicWebSocketTest;
import org.asynchttpclient.ws.EchoWebSocket;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.testng.annotations.Test;

public class WebSocketWriteFutureTest
extends AbstractBasicWebSocketTest {
    @Override
    public WebSocketHandler configureHandler() {
        return new WebSocketHandler(){

            public void configure(WebSocketServletFactory factory) {
                factory.register(EchoWebSocket.class);
            }
        };
    }

    @Test(timeOut=60000L)
    public void sendTextMessage() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            this.getWebSocket(c).sendTextFrame("TEXT").get(10L, TimeUnit.SECONDS);
        }
    }

    @Test(timeOut=60000L, expectedExceptions={ExecutionException.class})
    public void sendTextMessageExpectFailure() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            CountDownLatch closeLatch = new CountDownLatch(1);
            WebSocket websocket = this.getWebSocket(c, closeLatch);
            websocket.sendCloseFrame();
            closeLatch.await(1L, TimeUnit.SECONDS);
            websocket.sendTextFrame("TEXT").get(10L, TimeUnit.SECONDS);
        }
    }

    @Test(timeOut=60000L)
    public void sendByteMessage() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            this.getWebSocket(c).sendBinaryFrame("BYTES".getBytes()).get(10L, TimeUnit.SECONDS);
        }
    }

    @Test(timeOut=60000L, expectedExceptions={ExecutionException.class})
    public void sendByteMessageExpectFailure() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            CountDownLatch closeLatch = new CountDownLatch(1);
            WebSocket websocket = this.getWebSocket(c, closeLatch);
            websocket.sendCloseFrame();
            closeLatch.await(1L, TimeUnit.SECONDS);
            websocket.sendBinaryFrame("BYTES".getBytes()).get(10L, TimeUnit.SECONDS);
        }
    }

    @Test(timeOut=60000L)
    public void sendPingMessage() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            this.getWebSocket(c).sendPingFrame("PING".getBytes()).get(10L, TimeUnit.SECONDS);
        }
    }

    @Test(timeOut=60000L, expectedExceptions={ExecutionException.class})
    public void sendPingMessageExpectFailure() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            CountDownLatch closeLatch = new CountDownLatch(1);
            WebSocket websocket = this.getWebSocket(c, closeLatch);
            websocket.sendCloseFrame();
            closeLatch.await(1L, TimeUnit.SECONDS);
            websocket.sendPingFrame("PING".getBytes()).get(10L, TimeUnit.SECONDS);
        }
    }

    @Test(timeOut=60000L)
    public void sendPongMessage() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            this.getWebSocket(c).sendPongFrame("PONG".getBytes()).get(10L, TimeUnit.SECONDS);
        }
    }

    @Test(timeOut=60000L, expectedExceptions={ExecutionException.class})
    public void sendPongMessageExpectFailure() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            CountDownLatch closeLatch = new CountDownLatch(1);
            WebSocket websocket = this.getWebSocket(c, closeLatch);
            websocket.sendCloseFrame();
            closeLatch.await(1L, TimeUnit.SECONDS);
            websocket.sendPongFrame("PONG".getBytes()).get(1L, TimeUnit.SECONDS);
        }
    }

    @Test(timeOut=60000L)
    public void streamBytes() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            this.getWebSocket(c).sendBinaryFrame("STREAM".getBytes(), true, 0).get(1L, TimeUnit.SECONDS);
        }
    }

    @Test(timeOut=60000L, expectedExceptions={ExecutionException.class})
    public void streamBytesExpectFailure() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            CountDownLatch closeLatch = new CountDownLatch(1);
            WebSocket websocket = this.getWebSocket(c, closeLatch);
            websocket.sendCloseFrame();
            closeLatch.await(1L, TimeUnit.SECONDS);
            websocket.sendBinaryFrame("STREAM".getBytes(), true, 0).get(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void streamText() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            this.getWebSocket(c).sendTextFrame("STREAM", true, 0).get(1L, TimeUnit.SECONDS);
        }
    }

    @Test(expectedExceptions={ExecutionException.class})
    public void streamTextExpectFailure() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            CountDownLatch closeLatch = new CountDownLatch(1);
            WebSocket websocket = this.getWebSocket(c, closeLatch);
            websocket.sendCloseFrame();
            closeLatch.await(1L, TimeUnit.SECONDS);
            websocket.sendTextFrame("STREAM", true, 0).get(1L, TimeUnit.SECONDS);
        }
    }

    private WebSocket getWebSocket(AsyncHttpClient c) throws Exception {
        return (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().build()).get();
    }

    private WebSocket getWebSocket(AsyncHttpClient c, final CountDownLatch closeLatch) throws Exception {
        return (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

            public void onOpen(WebSocket websocket) {
            }

            public void onError(Throwable t) {
            }

            public void onClose(WebSocket websocket, int code, String reason) {
                closeLatch.countDown();
            }
        }).build()).get();
    }
}

