/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.ws;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.test.TestUtils;
import org.asynchttpclient.ws.AbstractBasicWebSocketTest;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RedirectTest
extends AbstractBasicWebSocketTest {
    @Override
    @BeforeClass
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        ServerConnector connector1 = TestUtils.addHttpConnector(this.server);
        ServerConnector connector2 = TestUtils.addHttpConnector(this.server);
        HandlerList list = new HandlerList();
        list.addHandler((Handler)new AbstractHandler(){

            public void handle(String s, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
                if (request.getLocalPort() == RedirectTest.this.port2) {
                    httpServletResponse.sendRedirect(RedirectTest.this.getTargetUrl());
                }
            }
        });
        list.addHandler((Handler)this.configureHandler());
        this.server.setHandler((Handler)list);
        this.server.start();
        this.port1 = connector1.getLocalPort();
        this.port2 = connector2.getLocalPort();
        this.logger.info("Local HTTP server started successfully");
    }

    @Test(timeOut=60000L)
    public void testRedirectToWSResource() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true));){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)c.prepareGet(this.getRedirectURL()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(WebSocket websocket) {
                    text.set("OnOpen");
                    latch.countDown();
                }

                public void onClose(WebSocket websocket, int code, String reason) {
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"OnOpen");
            websocket.sendCloseFrame();
        }
    }

    private String getRedirectURL() {
        return String.format("ws://localhost:%d/", this.port2);
    }
}

