/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.util;

import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaderValues;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Param;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.netty.util.ByteBufUtils;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.HttpUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HttpUtilsTest {
    private static String toUsAsciiString(ByteBuffer buf) {
        ByteBuf bb = Unpooled.wrappedBuffer((ByteBuffer)buf);
        try {
            String string = ByteBufUtils.byteBuf2String((Charset)StandardCharsets.US_ASCII, (ByteBuf)bb);
            return string;
        }
        finally {
            bb.release();
        }
    }

    @Test
    public void testExtractCharsetWithoutQuotes() {
        Charset charset = HttpUtils.extractContentTypeCharsetAttribute((String)"text/html; charset=iso-8859-1");
        Assert.assertEquals((Object)charset, (Object)StandardCharsets.ISO_8859_1);
    }

    @Test
    public void testExtractCharsetWithSingleQuotes() {
        Charset charset = HttpUtils.extractContentTypeCharsetAttribute((String)"text/html; charset='iso-8859-1'");
        Assert.assertEquals((Object)charset, (Object)StandardCharsets.ISO_8859_1);
    }

    @Test
    public void testExtractCharsetWithDoubleQuotes() {
        Charset charset = HttpUtils.extractContentTypeCharsetAttribute((String)"text/html; charset=\"iso-8859-1\"");
        Assert.assertEquals((Object)charset, (Object)StandardCharsets.ISO_8859_1);
    }

    @Test
    public void testExtractCharsetWithDoubleQuotesAndSpaces() {
        Charset charset = HttpUtils.extractContentTypeCharsetAttribute((String)"text/html; charset= \"iso-8859-1\" ");
        Assert.assertEquals((Object)charset, (Object)StandardCharsets.ISO_8859_1);
    }

    @Test
    public void testExtractCharsetFallsBackToUtf8() {
        Charset charset = HttpUtils.extractContentTypeCharsetAttribute((String)HttpHeaderValues.APPLICATION_JSON.toString());
        Assert.assertNull((Object)charset);
    }

    @Test
    public void testGetHostHeader() {
        Uri uri = Uri.create((String)"http://stackoverflow.com/questions/1057564/pretty-git-branch-graphs");
        String hostHeader = HttpUtils.hostHeader((Uri)uri);
        Assert.assertEquals((String)hostHeader, (String)"stackoverflow.com", (String)"Incorrect hostHeader returned");
    }

    @Test
    public void testDefaultFollowRedirect() {
        Request request = ((RequestBuilder)Dsl.get((String)"http://stackoverflow.com/questions/1057564").setVirtualHost("example.com")).build();
        DefaultAsyncHttpClientConfig config = new DefaultAsyncHttpClientConfig.Builder().build();
        boolean followRedirect = HttpUtils.followRedirect((AsyncHttpClientConfig)config, (Request)request);
        Assert.assertFalse((boolean)followRedirect, (String)"Default value of redirect should be false");
    }

    @Test
    public void testGetFollowRedirectInRequest() {
        Request request = ((RequestBuilder)Dsl.get((String)"http://stackoverflow.com/questions/1057564").setFollowRedirect(true)).build();
        DefaultAsyncHttpClientConfig config = new DefaultAsyncHttpClientConfig.Builder().build();
        boolean followRedirect = HttpUtils.followRedirect((AsyncHttpClientConfig)config, (Request)request);
        Assert.assertTrue((boolean)followRedirect, (String)"Follow redirect must be true as set in the request");
    }

    @Test
    public void testGetFollowRedirectInConfig() {
        Request request = Dsl.get((String)"http://stackoverflow.com/questions/1057564").build();
        DefaultAsyncHttpClientConfig config = new DefaultAsyncHttpClientConfig.Builder().setFollowRedirect(true).build();
        boolean followRedirect = HttpUtils.followRedirect((AsyncHttpClientConfig)config, (Request)request);
        Assert.assertTrue((boolean)followRedirect, (String)"Follow redirect should be equal to value specified in config when not specified in request");
    }

    @Test
    public void testGetFollowRedirectPriorityGivenToRequest() {
        Request request = ((RequestBuilder)Dsl.get((String)"http://stackoverflow.com/questions/1057564").setFollowRedirect(false)).build();
        DefaultAsyncHttpClientConfig config = new DefaultAsyncHttpClientConfig.Builder().setFollowRedirect(true).build();
        boolean followRedirect = HttpUtils.followRedirect((AsyncHttpClientConfig)config, (Request)request);
        Assert.assertFalse((boolean)followRedirect, (String)"Follow redirect value set in request should be given priority");
    }

    private void formUrlEncoding(Charset charset) throws Exception {
        String key = "key";
        String value = "\u4e2d\u6587";
        ArrayList<Param> params = new ArrayList<Param>();
        params.add(new Param(key, value));
        ByteBuffer ahcBytes = HttpUtils.urlEncodeFormParams(params, (Charset)charset);
        String ahcString = HttpUtilsTest.toUsAsciiString(ahcBytes);
        String jdkString = key + "=" + URLEncoder.encode(value, charset.name());
        Assert.assertEquals((String)ahcString, (String)jdkString);
    }

    @Test
    public void formUrlEncodingShouldSupportUtf8Charset() throws Exception {
        this.formUrlEncoding(StandardCharsets.UTF_8);
    }

    @Test
    public void formUrlEncodingShouldSupportNonUtf8Charset() throws Exception {
        this.formUrlEncoding(Charset.forName("GBK"));
    }

    @Test
    public void computeOriginForPlainUriWithImplicitPort() {
        Assert.assertEquals((String)HttpUtils.originHeader((Uri)Uri.create((String)"ws://foo.com/bar")), (String)"http://foo.com");
    }

    @Test
    public void computeOriginForPlainUriWithDefaultPort() {
        Assert.assertEquals((String)HttpUtils.originHeader((Uri)Uri.create((String)"ws://foo.com:80/bar")), (String)"http://foo.com");
    }

    @Test
    public void computeOriginForPlainUriWithNonDefaultPort() {
        Assert.assertEquals((String)HttpUtils.originHeader((Uri)Uri.create((String)"ws://foo.com:81/bar")), (String)"http://foo.com:81");
    }

    @Test
    public void computeOriginForSecuredUriWithImplicitPort() {
        Assert.assertEquals((String)HttpUtils.originHeader((Uri)Uri.create((String)"wss://foo.com/bar")), (String)"https://foo.com");
    }

    @Test
    public void computeOriginForSecuredUriWithDefaultPort() {
        Assert.assertEquals((String)HttpUtils.originHeader((Uri)Uri.create((String)"wss://foo.com:443/bar")), (String)"https://foo.com");
    }

    @Test
    public void computeOriginForSecuredUriWithNonDefaultPort() {
        Assert.assertEquals((String)HttpUtils.originHeader((Uri)Uri.create((String)"wss://foo.com:444/bar")), (String)"https://foo.com:444");
    }
}

