/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.uri;

import java.net.URI;
import org.asynchttpclient.uri.Uri;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UriTest {
    private static void assertUriEquals(Uri uri, URI javaUri) {
        Assert.assertEquals((String)uri.getScheme(), (String)javaUri.getScheme());
        Assert.assertEquals((String)uri.getUserInfo(), (String)javaUri.getUserInfo());
        Assert.assertEquals((String)uri.getHost(), (String)javaUri.getHost());
        Assert.assertEquals((int)uri.getPort(), (int)javaUri.getPort());
        Assert.assertEquals((String)uri.getPath(), (String)javaUri.getPath());
        Assert.assertEquals((String)uri.getQuery(), (String)javaUri.getQuery());
    }

    private static void validateAgainstAbsoluteURI(String url) {
        UriTest.assertUriEquals(Uri.create((String)url), URI.create(url));
    }

    private static void validateAgainstRelativeURI(String context, String url) {
        UriTest.assertUriEquals(Uri.create((Uri)Uri.create((String)context), (String)url), URI.create(context).resolve(URI.create(url)));
    }

    @Test
    public void testSimpleParsing() {
        UriTest.validateAgainstAbsoluteURI("https://graph.facebook.com/750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testRootRelativeURIWithRootContext() {
        UriTest.validateAgainstRelativeURI("https://graph.facebook.com", "/750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testRootRelativeURIWithNonRootContext() {
        UriTest.validateAgainstRelativeURI("https://graph.facebook.com/foo/bar", "/750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testNonRootRelativeURIWithNonRootContext() {
        UriTest.validateAgainstRelativeURI("https://graph.facebook.com/foo/bar", "750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test(enabled=false)
    public void testNonRootRelativeURIWithRootContext() {
        UriTest.validateAgainstRelativeURI("https://graph.facebook.com", "750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testAbsoluteURIWithContext() {
        UriTest.validateAgainstRelativeURI("https://hello.com/foo/bar", "https://graph.facebook.com/750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testRelativeUriWithDots() {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1/level2/", "../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithDotsAboveRoot() {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1", "../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithAbsoluteDots() {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1/", "/../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithConsecutiveDots() {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1/level2/", "../../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsAboveRoot() {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1/level2", "../../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithAbsoluteConsecutiveDots() {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1/level2/", "/../../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsFromRoot() {
        UriTest.validateAgainstRelativeURI("https://hello.com/", "../../../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsFromRootResource() {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1", "../../../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsFromSubrootResource() {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1/level2", "../../../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsFromLevel3Resource() {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1/level2/level3", "../../../other/content/img.png");
    }

    @Test
    public void testRelativeUriWithNoScheme() {
        UriTest.validateAgainstRelativeURI("https://hello.com/level1", "//world.org/content/img.png");
    }

    @Test
    public void testCreateAndToUrl() {
        String url = "https://hello.com/level1/level2/level3";
        Uri uri = Uri.create((String)url);
        Assert.assertEquals((String)uri.toUrl(), (String)url, (String)"url used to create uri and url returned from toUrl do not match");
    }

    @Test
    public void testToUrlWithUserInfoPortPathAndQuery() {
        Uri uri = new Uri("http", "user", "example.com", 44, "/path/path2", "query=4", null);
        Assert.assertEquals((String)uri.toUrl(), (String)"http://user@example.com:44/path/path2?query=4", (String)"toUrl returned incorrect url");
    }

    @Test
    public void testQueryWithNonRootPath() {
        Uri uri = Uri.create((String)"http://hello.com/foo?query=value");
        Assert.assertEquals((String)uri.getPath(), (String)"/foo");
        Assert.assertEquals((String)uri.getQuery(), (String)"query=value");
    }

    @Test
    public void testQueryWithNonRootPathAndTrailingSlash() {
        Uri uri = Uri.create((String)"http://hello.com/foo/?query=value");
        Assert.assertEquals((String)uri.getPath(), (String)"/foo/");
        Assert.assertEquals((String)uri.getQuery(), (String)"query=value");
    }

    @Test
    public void testQueryWithRootPath() {
        Uri uri = Uri.create((String)"http://hello.com?query=value");
        Assert.assertEquals((String)uri.getPath(), (String)"");
        Assert.assertEquals((String)uri.getQuery(), (String)"query=value");
    }

    @Test
    public void testQueryWithRootPathAndTrailingSlash() {
        Uri uri = Uri.create((String)"http://hello.com/?query=value");
        Assert.assertEquals((String)uri.getPath(), (String)"/");
        Assert.assertEquals((String)uri.getQuery(), (String)"query=value");
    }

    @Test
    public void testWithNewScheme() {
        Uri uri = new Uri("http", "user", "example.com", 44, "/path/path2", "query=4", null);
        Uri newUri = uri.withNewScheme("https");
        Assert.assertEquals((String)newUri.getScheme(), (String)"https");
        Assert.assertEquals((String)newUri.toUrl(), (String)"https://user@example.com:44/path/path2?query=4", (String)"toUrl returned incorrect url");
    }

    @Test
    public void testWithNewQuery() {
        Uri uri = new Uri("http", "user", "example.com", 44, "/path/path2", "query=4", null);
        Uri newUri = uri.withNewQuery("query2=10&query3=20");
        Assert.assertEquals((String)newUri.getQuery(), (String)"query2=10&query3=20");
        Assert.assertEquals((String)newUri.toUrl(), (String)"http://user@example.com:44/path/path2?query2=10&query3=20", (String)"toUrl returned incorrect url");
    }

    @Test
    public void testToRelativeUrl() {
        Uri uri = new Uri("http", "user", "example.com", 44, "/path/path2", "query=4", null);
        String relativeUrl = uri.toRelativeUrl();
        Assert.assertEquals((String)relativeUrl, (String)"/path/path2?query=4", (String)"toRelativeUrl returned incorrect url");
    }

    @Test
    public void testToRelativeUrlWithEmptyPath() {
        Uri uri = new Uri("http", "user", "example.com", 44, null, "query=4", null);
        String relativeUrl = uri.toRelativeUrl();
        Assert.assertEquals((String)relativeUrl, (String)"/?query=4", (String)"toRelativeUrl returned incorrect url");
    }

    @Test
    public void testGetSchemeDefaultPortHttpScheme() {
        String url = "https://hello.com/level1/level2/level3";
        Uri uri = Uri.create((String)url);
        Assert.assertEquals((int)uri.getSchemeDefaultPort(), (int)443, (String)"schema default port should be 443 for https url");
        String url2 = "http://hello.com/level1/level2/level3";
        Uri uri2 = Uri.create((String)url2);
        Assert.assertEquals((int)uri2.getSchemeDefaultPort(), (int)80, (String)"schema default port should be 80 for http url");
    }

    @Test
    public void testGetSchemeDefaultPortWebSocketScheme() {
        String url = "wss://hello.com/level1/level2/level3";
        Uri uri = Uri.create((String)url);
        Assert.assertEquals((int)uri.getSchemeDefaultPort(), (int)443, (String)"schema default port should be 443 for wss url");
        String url2 = "ws://hello.com/level1/level2/level3";
        Uri uri2 = Uri.create((String)url2);
        Assert.assertEquals((int)uri2.getSchemeDefaultPort(), (int)80, (String)"schema default port should be 80 for ws url");
    }

    @Test
    public void testGetExplicitPort() {
        String url = "http://hello.com/level1/level2/level3";
        Uri uri = Uri.create((String)url);
        Assert.assertEquals((int)uri.getExplicitPort(), (int)80, (String)"getExplicitPort should return port 80 for http url when port is not specified in url");
        String url2 = "http://hello.com:8080/level1/level2/level3";
        Uri uri2 = Uri.create((String)url2);
        Assert.assertEquals((int)uri2.getExplicitPort(), (int)8080, (String)"getExplicitPort should return the port given in the url");
    }

    @Test
    public void testEquals() {
        String url = "http://user@hello.com:8080/level1/level2/level3?q=1";
        Uri createdUri = Uri.create((String)url);
        Uri constructedUri = new Uri("http", "user", "hello.com", 8080, "/level1/level2/level3", "q=1", null);
        Assert.assertTrue((boolean)createdUri.equals((Object)constructedUri), (String)"The equals method returned false for two equal urls");
    }

    @Test
    void testFragment() {
        String url = "http://user@hello.com:8080/level1/level2/level3?q=1";
        String fragment = "foo";
        String urlWithFragment = url + "#" + fragment;
        Uri uri = Uri.create((String)urlWithFragment);
        Assert.assertEquals((String)fragment, (String)uri.getFragment(), (String)"Fragment should be extracted");
        Assert.assertEquals((String)uri.toUrl(), (String)url, (String)"toUrl should return without fragment");
        Assert.assertEquals((String)uri.toFullUrl(), (String)urlWithFragment, (String)"toFullUrl should return with fragment");
    }

    @Test
    void testRelativeFragment() {
        Uri uri = Uri.create((Uri)Uri.create((String)"http://user@hello.com:8080"), (String)"/level1/level2/level3?q=1#foo");
        Assert.assertEquals((String)"foo", (String)uri.getFragment(), (String)"fragment should be kept when computing a relative url");
    }

    @Test
    public void testIsWebsocket() {
        String url = "http://user@hello.com:8080/level1/level2/level3?q=1";
        Uri uri = Uri.create((String)url);
        Assert.assertFalse((boolean)uri.isWebSocket(), (String)"isWebSocket should return false for http url");
        url = "https://user@hello.com:8080/level1/level2/level3?q=1";
        uri = Uri.create((String)url);
        Assert.assertFalse((boolean)uri.isWebSocket(), (String)"isWebSocket should return false for https url");
        url = "ws://user@hello.com:8080/level1/level2/level3?q=1";
        uri = Uri.create((String)url);
        Assert.assertTrue((boolean)uri.isWebSocket(), (String)"isWebSocket should return true for ws url");
        url = "wss://user@hello.com:8080/level1/level2/level3?q=1";
        uri = Uri.create((String)url);
        Assert.assertTrue((boolean)uri.isWebSocket(), (String)"isWebSocket should return true for wss url");
    }

    @Test
    public void creatingUriWithDefinedSchemeAndHostWorks() {
        Uri.create((String)"http://localhost");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void creatingUriWithMissingSchemeThrowsIllegalArgumentException() {
        Uri.create((String)"localhost");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void creatingUriWithMissingHostThrowsIllegalArgumentException() {
        Uri.create((String)"http://");
    }

    @Test
    public void testGetAuthority() {
        Uri uri = Uri.create((String)"http://stackoverflow.com/questions/17814461/jacoco-maven-testng-0-test-coverage");
        Assert.assertEquals((String)uri.getAuthority(), (String)"stackoverflow.com:80", (String)"Incorrect authority returned from getAuthority");
    }

    @Test
    public void testGetAuthorityWithPortInUrl() {
        Uri uri = Uri.create((String)"http://stackoverflow.com:8443/questions/17814461/jacoco-maven-testng-0-test-coverage");
        Assert.assertEquals((String)uri.getAuthority(), (String)"stackoverflow.com:8443", (String)"Incorrect authority returned from getAuthority");
    }

    @Test
    public void testGetBaseUrl() {
        Uri uri = Uri.create((String)"http://stackoverflow.com:8443/questions/17814461/jacoco-maven-testng-0-test-coverage");
        Assert.assertEquals((String)uri.getBaseUrl(), (String)"http://stackoverflow.com:8443", (String)"Incorrect base URL returned from getBaseURL");
    }

    @Test
    public void testIsSameBaseUrlReturnsFalseWhenPortDifferent() {
        Uri uri1 = Uri.create((String)"http://stackoverflow.com:8443/questions/17814461/jacoco-maven-testng-0-test-coverage");
        Uri uri2 = Uri.create((String)"http://stackoverflow.com:8442/questions/1057564/pretty-git-branch-graphs");
        Assert.assertFalse((boolean)uri1.isSameBase(uri2), (String)"Base URLs should be different, but true was returned from isSameBase");
    }

    @Test
    public void testIsSameBaseUrlReturnsFalseWhenSchemeDifferent() {
        Uri uri1 = Uri.create((String)"http://stackoverflow.com:8443/questions/17814461/jacoco-maven-testng-0-test-coverage");
        Uri uri2 = Uri.create((String)"ws://stackoverflow.com:8443/questions/1057564/pretty-git-branch-graphs");
        Assert.assertFalse((boolean)uri1.isSameBase(uri2), (String)"Base URLs should be different, but true was returned from isSameBase");
    }

    @Test
    public void testIsSameBaseUrlReturnsFalseWhenHostDifferent() {
        Uri uri1 = Uri.create((String)"http://stackoverflow.com:8443/questions/17814461/jacoco-maven-testng-0-test-coverage");
        Uri uri2 = Uri.create((String)"http://example.com:8443/questions/1057564/pretty-git-branch-graphs");
        Assert.assertFalse((boolean)uri1.isSameBase(uri2), (String)"Base URLs should be different, but true was returned from isSameBase");
    }

    @Test
    public void testIsSameBaseUrlReturnsTrueWhenOneUriHasDefaultPort() {
        Uri uri1 = Uri.create((String)"http://stackoverflow.com:80/questions/17814461/jacoco-maven-testng-0-test-coverage");
        Uri uri2 = Uri.create((String)"http://stackoverflow.com/questions/1057564/pretty-git-branch-graphs");
        Assert.assertTrue((boolean)uri1.isSameBase(uri2), (String)"Base URLs should be same, but false was returned from isSameBase");
    }

    @Test
    public void testGetPathWhenPathIsNonEmpty() {
        Uri uri = Uri.create((String)"http://stackoverflow.com:8443/questions/17814461/jacoco-maven-testng-0-test-coverage");
        Assert.assertEquals((String)uri.getNonEmptyPath(), (String)"/questions/17814461/jacoco-maven-testng-0-test-coverage", (String)"Incorrect path returned from getNonEmptyPath");
    }

    @Test
    public void testGetPathWhenPathIsEmpty() {
        Uri uri = Uri.create((String)"http://stackoverflow.com");
        Assert.assertEquals((String)uri.getNonEmptyPath(), (String)"/", (String)"Incorrect path returned from getNonEmptyPath");
    }
}

