/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.uri;

import java.net.URI;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.uri.UriParser;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UriParserTest {
    private static void assertUriEquals(UriParser parser, URI uri) {
        Assert.assertEquals((String)parser.scheme, (String)uri.getScheme());
        Assert.assertEquals((String)parser.userInfo, (String)uri.getUserInfo());
        Assert.assertEquals((String)parser.host, (String)uri.getHost());
        Assert.assertEquals((int)parser.port, (int)uri.getPort());
        Assert.assertEquals((String)parser.path, (String)uri.getPath());
        Assert.assertEquals((String)parser.query, (String)uri.getQuery());
    }

    private static void validateAgainstAbsoluteURI(String url) {
        UriParser parser = new UriParser();
        parser.parse(null, url);
        UriParserTest.assertUriEquals(parser, URI.create(url));
    }

    private static void validateAgainstRelativeURI(Uri uriContext, String urlContext, String url) {
        UriParser parser = new UriParser();
        parser.parse(uriContext, url);
        UriParserTest.assertUriEquals(parser, URI.create(urlContext).resolve(URI.create(url)));
    }

    @Test
    public void testUrlWithPathAndQuery() {
        UriParserTest.validateAgainstAbsoluteURI("http://example.com:8080/test?q=1");
    }

    @Test
    public void testFragmentTryingToTrickAuthorityAsBasicAuthCredentials() {
        UriParserTest.validateAgainstAbsoluteURI("http://1.2.3.4:81#@5.6.7.8:82/aaa/b?q=xxx");
    }

    @Test
    public void testUrlHasLeadingAndTrailingWhiteSpace() {
        UriParser parser = new UriParser();
        String url = "  http://user@example.com:8080/test?q=1  ";
        parser.parse(null, url);
        UriParserTest.assertUriEquals(parser, URI.create(url.trim()));
    }

    @Test
    public void testResolveAbsoluteUriAgainstContext() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "", null);
        UriParserTest.validateAgainstRelativeURI(context, "https://example.com:80/path", "http://example.com/path");
    }

    @Test
    public void testRootRelativePath() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "q=2", null);
        UriParserTest.validateAgainstRelativeURI(context, "https://example.com:80/path?q=2", "/relativeUrl");
    }

    @Test
    public void testCurrentDirRelativePath() {
        Uri context = new Uri("https", null, "example.com", 80, "/foo/bar", "q=2", null);
        UriParserTest.validateAgainstRelativeURI(context, "https://example.com:80/foo/bar?q=2", "relativeUrl");
    }

    @Test
    public void testFragmentOnly() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "q=2", null);
        UriParserTest.validateAgainstRelativeURI(context, "https://example.com:80/path?q=2", "#test");
    }

    @Test
    public void testRelativeUrlWithQuery() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "q=2", null);
        UriParserTest.validateAgainstRelativeURI(context, "https://example.com:80/path?q=2", "/relativePath?q=3");
    }

    @Test
    public void testRelativeUrlWithQueryOnly() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "q=2", null);
        UriParserTest.validateAgainstRelativeURI(context, "https://example.com:80/path?q=2", "?q=3");
    }

    @Test
    public void testRelativeURLWithDots() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "q=2", null);
        UriParserTest.validateAgainstRelativeURI(context, "https://example.com:80/path?q=2", "./relative/./url");
    }

    @Test
    public void testRelativeURLWithTwoEmbeddedDots() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "q=2", null);
        UriParserTest.validateAgainstRelativeURI(context, "https://example.com:80/path?q=2", "./relative/../url");
    }

    @Test
    public void testRelativeURLWithTwoTrailingDots() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "q=2", null);
        UriParserTest.validateAgainstRelativeURI(context, "https://example.com:80/path?q=2", "./relative/url/..");
    }

    @Test
    public void testRelativeURLWithOneTrailingDot() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "q=2", null);
        UriParserTest.validateAgainstRelativeURI(context, "https://example.com:80/path?q=2", "./relative/url/.");
    }
}

