/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.testserver;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Set;

public class SocksProxy {
    private static ArrayList<SocksClient> clients = new ArrayList();

    public SocksProxy(int runningTime) throws IOException {
        ServerSocketChannel socks = ServerSocketChannel.open();
        socks.socket().bind(new InetSocketAddress(8000));
        socks.configureBlocking(false);
        Selector select = Selector.open();
        socks.register(select, 16);
        int lastClients = clients.size();
        long end = System.currentTimeMillis() + (long)runningTime;
        while (System.currentTimeMillis() < end) {
            select.select(5000L);
            Set<SelectionKey> keys = select.selectedKeys();
            for (SelectionKey k : keys) {
                if (!k.isValid()) continue;
                if (k.isAcceptable() && k.channel() == socks) {
                    SocketChannel csock = socks.accept();
                    if (csock == null) continue;
                    this.addClient(csock);
                    csock.register(select, 1);
                    continue;
                }
                if (!k.isReadable()) continue;
                for (int i = 0; i < clients.size(); ++i) {
                    SocksClient cl = clients.get(i);
                    try {
                        if (k.channel() == cl.client) {
                            cl.newClientData(select);
                            continue;
                        }
                        if (k.channel() != cl.remote) continue;
                        cl.newRemoteData();
                        continue;
                    }
                    catch (IOException e) {
                        cl.client.close();
                        if (cl.remote != null) {
                            cl.remote.close();
                        }
                        k.cancel();
                        clients.remove(cl);
                    }
                }
            }
            for (int i = 0; i < clients.size(); ++i) {
                SocksClient cl = clients.get(i);
                if (System.currentTimeMillis() - cl.lastData <= 30000L) continue;
                cl.client.close();
                if (cl.remote != null) {
                    cl.remote.close();
                }
                clients.remove(cl);
            }
            if (clients.size() == lastClients) continue;
            System.out.println(clients.size());
            lastClients = clients.size();
        }
    }

    private void addClient(SocketChannel s) {
        SocksClient cl;
        try {
            cl = new SocksClient(s);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        clients.add(cl);
    }

    class SocksClient {
        SocketChannel client;
        SocketChannel remote;
        boolean connected;
        long lastData;

        SocksClient(SocketChannel c) throws IOException {
            this.client = c;
            this.client.configureBlocking(false);
            this.lastData = System.currentTimeMillis();
        }

        void newRemoteData() throws IOException {
            ByteBuffer buf = ByteBuffer.allocate(1024);
            if (this.remote.read(buf) == -1) {
                throw new IOException("disconnected");
            }
            this.lastData = System.currentTimeMillis();
            buf.flip();
            this.client.write(buf);
        }

        void newClientData(Selector selector) throws IOException {
            if (!this.connected) {
                ByteBuffer inbuf = ByteBuffer.allocate(512);
                if (this.client.read(inbuf) < 1) {
                    return;
                }
                inbuf.flip();
                byte ver = inbuf.get();
                if (ver != 4) {
                    throw new IOException("incorrect version" + ver);
                }
                byte cmd = inbuf.get();
                if (cmd != 1) {
                    throw new IOException("incorrect version");
                }
                int port = inbuf.getShort() & 0xFFFF;
                byte[] ip = new byte[4];
                inbuf.get(ip);
                InetAddress remoteAddr = InetAddress.getByAddress(ip);
                while (inbuf.get() != 0) {
                }
                if (ip[0] == 0 && ip[1] == 0 && ip[2] == 0 && ip[3] != 0) {
                    byte b;
                    StringBuilder host = new StringBuilder();
                    while ((b = inbuf.get()) != 0) {
                        host.append(b);
                    }
                    remoteAddr = InetAddress.getByName(host.toString());
                    System.out.println(host.toString() + remoteAddr);
                }
                this.remote = SocketChannel.open(new InetSocketAddress(remoteAddr, port));
                ByteBuffer out = ByteBuffer.allocate(20);
                out.put((byte)0);
                out.put((byte)(this.remote.isConnected() ? 90 : 91));
                out.putShort((short)port);
                out.put(remoteAddr.getAddress());
                out.flip();
                this.client.write(out);
                if (!this.remote.isConnected()) {
                    throw new IOException("connect failed");
                }
                this.remote.configureBlocking(false);
                this.remote.register(selector, 1);
                this.connected = true;
            } else {
                ByteBuffer buf = ByteBuffer.allocate(1024);
                if (this.client.read(buf) == -1) {
                    throw new IOException("disconnected");
                }
                this.lastData = System.currentTimeMillis();
                buf.flip();
                this.remote.write(buf);
            }
        }
    }
}

