/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.testserver;

import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.testserver.HttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpTest {
    protected static final String COMPLETED_EVENT = "Completed";
    protected static final String STATUS_RECEIVED_EVENT = "StatusReceived";
    protected static final String HEADERS_RECEIVED_EVENT = "HeadersReceived";
    protected static final String HEADERS_WRITTEN_EVENT = "HeadersWritten";
    protected static final String CONNECTION_OPEN_EVENT = "ConnectionOpen";
    protected static final String HOSTNAME_RESOLUTION_EVENT = "HostnameResolution";
    protected static final String HOSTNAME_RESOLUTION_SUCCESS_EVENT = "HostnameResolutionSuccess";
    protected static final String CONNECTION_SUCCESS_EVENT = "ConnectionSuccess";
    protected static final String TLS_HANDSHAKE_EVENT = "TlsHandshake";
    protected static final String TLS_HANDSHAKE_SUCCESS_EVENT = "TlsHandshakeSuccess";
    protected static final String CONNECTION_POOL_EVENT = "ConnectionPool";
    protected static final String CONNECTION_OFFER_EVENT = "ConnectionOffer";
    protected static final String REQUEST_SEND_EVENT = "RequestSend";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected ClientTestBody withClient() {
        return this.withClient(Dsl.config().setMaxRedirects(0));
    }

    protected ClientTestBody withClient(DefaultAsyncHttpClientConfig.Builder builder) {
        return this.withClient((AsyncHttpClientConfig)builder.build());
    }

    private ClientTestBody withClient(AsyncHttpClientConfig config) {
        return new ClientTestBody(config);
    }

    protected ServerTestBody withServer(HttpServer server) {
        return new ServerTestBody(server);
    }

    protected static class ServerTestBody {
        private final HttpServer server;

        private ServerTestBody(HttpServer server) {
            this.server = server;
        }

        public void run(ServerFunction f) throws Throwable {
            try {
                f.apply(this.server);
            }
            finally {
                this.server.reset();
            }
        }
    }

    protected static class ClientTestBody {
        private final AsyncHttpClientConfig config;

        private ClientTestBody(AsyncHttpClientConfig config) {
            this.config = config;
        }

        public void run(ClientFunction f) throws Throwable {
            try (AsyncHttpClient client = Dsl.asyncHttpClient((AsyncHttpClientConfig)this.config);){
                f.apply(client);
            }
        }
    }

    @FunctionalInterface
    protected static interface ServerFunction {
        public void apply(HttpServer var1) throws Throwable;
    }

    @FunctionalInterface
    protected static interface ClientFunction {
        public void apply(AsyncHttpClient var1) throws Throwable;
    }
}

