/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.generator;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.generator.FeedListener;
import org.asynchttpclient.request.body.generator.UnboundedQueueFeedableBodyGenerator;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FeedableBodyGeneratorTest {
    private UnboundedQueueFeedableBodyGenerator feedableBodyGenerator;
    private TestFeedListener listener;

    @BeforeMethod
    public void setUp() {
        this.feedableBodyGenerator = new UnboundedQueueFeedableBodyGenerator();
        this.listener = new TestFeedListener();
        this.feedableBodyGenerator.setListener((FeedListener)this.listener);
    }

    @Test
    public void feedNotifiesListener() throws Exception {
        this.feedableBodyGenerator.feed(Unpooled.EMPTY_BUFFER, false);
        this.feedableBodyGenerator.feed(Unpooled.EMPTY_BUFFER, true);
        Assert.assertEquals((int)this.listener.getCalls(), (int)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readingBytesReturnsFedContentWithoutChunkBoundaries() throws Exception {
        byte[] content = "Test123".getBytes(StandardCharsets.US_ASCII);
        ByteBuf source = Unpooled.wrappedBuffer((byte[])content);
        ByteBuf target = Unpooled.buffer((int)1);
        try {
            this.feedableBodyGenerator.feed(source, true);
            Body body = this.feedableBodyGenerator.createBody();
            Assert.assertEquals((byte[])this.readFromBody(body), (byte[])"Test123".getBytes(StandardCharsets.US_ASCII));
            Assert.assertEquals((Object)body.transferTo(target), (Object)Body.BodyState.STOP);
        }
        finally {
            source.release();
            target.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void returnZeroToSuspendStreamWhenNothingIsInQueue() throws Exception {
        byte[] content = "Test123".getBytes(StandardCharsets.US_ASCII);
        ByteBuf source = Unpooled.wrappedBuffer((byte[])content);
        ByteBuf target = Unpooled.buffer((int)1);
        try {
            this.feedableBodyGenerator.feed(source, false);
            Body body = this.feedableBodyGenerator.createBody();
            Assert.assertEquals((byte[])this.readFromBody(body), (byte[])"Test123".getBytes(StandardCharsets.US_ASCII));
            Assert.assertEquals((Object)body.transferTo(target), (Object)Body.BodyState.SUSPEND);
        }
        finally {
            source.release();
            target.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFromBody(Body body) throws IOException {
        ByteBuf byteBuf = Unpooled.buffer((int)512);
        try {
            body.transferTo(byteBuf);
            byte[] readBytes = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(readBytes);
            byte[] byArray = readBytes;
            return byArray;
        }
        finally {
            byteBuf.release();
        }
    }

    private static class TestFeedListener
    implements FeedListener {
        private int calls;

        private TestFeedListener() {
        }

        public void onContentAdded() {
            ++this.calls;
        }

        public void onError(Throwable t) {
        }

        int getCalls() {
            return this.calls;
        }
    }
}

