/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.generator;

import java.io.IOException;
import java.util.Random;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.generator.ByteArrayBodyGenerator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ByteArrayBodyGeneratorTest {
    private final Random random = new Random();
    private final int chunkSize = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleRead() throws IOException {
        int srcArraySize = 8191;
        byte[] srcArray = new byte[8191];
        this.random.nextBytes(srcArray);
        ByteArrayBodyGenerator babGen = new ByteArrayBodyGenerator(srcArray);
        Body body = babGen.createBody();
        ByteBuf chunkBuffer = Unpooled.buffer((int)8192);
        try {
            body.transferTo(chunkBuffer);
            Assert.assertEquals((int)chunkBuffer.readableBytes(), (int)8191, (String)"bytes read");
            chunkBuffer.clear();
            Assert.assertEquals((Object)body.transferTo(chunkBuffer), (Object)Body.BodyState.STOP, (String)"body at EOF");
        }
        finally {
            chunkBuffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleReads() throws IOException {
        int srcArraySize = 24618;
        byte[] srcArray = new byte[24618];
        this.random.nextBytes(srcArray);
        ByteArrayBodyGenerator babGen = new ByteArrayBodyGenerator(srcArray);
        Body body = babGen.createBody();
        ByteBuf chunkBuffer = Unpooled.buffer((int)8192);
        try {
            int reads = 0;
            int bytesRead = 0;
            while (body.transferTo(chunkBuffer) != Body.BodyState.STOP) {
                ++reads;
                bytesRead += chunkBuffer.readableBytes();
                chunkBuffer.clear();
            }
            Assert.assertEquals((int)reads, (int)4, (String)"reads to drain generator");
            Assert.assertEquals((int)bytesRead, (int)24618, (String)"bytes read");
        }
        finally {
            chunkBuffer.release();
        }
    }
}

