/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaders;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ZeroCopyFileTest
extends AbstractBasicTest {
    @Test
    public void zeroCopyPostTest() throws IOException, ExecutionException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            final AtomicBoolean headerSent = new AtomicBoolean(false);
            final AtomicBoolean operationCompleted = new AtomicBoolean(false);
            Response resp = (Response)((BoundRequestBuilder)client.preparePost("http://localhost:" + this.port1 + "/").setBody(TestUtils.SIMPLE_TEXT_FILE)).execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

                public AsyncHandler.State onHeadersWritten() {
                    headerSent.set(true);
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onContentWritten() {
                    operationCompleted.set(true);
                    return AsyncHandler.State.CONTINUE;
                }

                public Response onCompleted(Response response) {
                    return response;
                }
            }).get();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getResponseBody(), (String)TestUtils.SIMPLE_TEXT_FILE_STRING);
            Assert.assertTrue((boolean)operationCompleted.get());
            Assert.assertTrue((boolean)headerSent.get());
        }
    }

    @Test
    public void zeroCopyPutTest() throws IOException, ExecutionException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            ListenableFuture f = ((BoundRequestBuilder)client.preparePut("http://localhost:" + this.port1 + "/").setBody(TestUtils.SIMPLE_TEXT_FILE)).execute();
            Response resp = (Response)f.get();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getResponseBody(), (String)TestUtils.SIMPLE_TEXT_FILE_STRING);
        }
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new ZeroCopyHandler();
    }

    @Test
    public void zeroCopyFileTest() throws IOException, ExecutionException, InterruptedException {
        File tmp = new File(System.getProperty("java.io.tmpdir") + File.separator + "zeroCopy.txt");
        tmp.deleteOnExit();
        try (AsyncHttpClient client = Dsl.asyncHttpClient();
             final OutputStream stream = Files.newOutputStream(tmp.toPath(), new OpenOption[0]);){
            Response resp = (Response)((BoundRequestBuilder)client.preparePost("http://localhost:" + this.port1 + "/").setBody(TestUtils.SIMPLE_TEXT_FILE)).execute((AsyncHandler)new AsyncHandler<Response>(){

                public void onThrowable(Throwable t) {
                }

                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    stream.write(bodyPart.getBodyPartBytes());
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) {
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onHeadersReceived(HttpHeaders headers) {
                    return AsyncHandler.State.CONTINUE;
                }

                public Response onCompleted() {
                    return null;
                }
            }).get();
            Assert.assertNull((Object)resp);
            Assert.assertEquals((long)TestUtils.SIMPLE_TEXT_FILE.length(), (long)tmp.length());
        }
    }

    @Test
    public void zeroCopyFileWithBodyManipulationTest() throws IOException, ExecutionException, InterruptedException {
        File tmp = new File(System.getProperty("java.io.tmpdir") + File.separator + "zeroCopy.txt");
        tmp.deleteOnExit();
        try (AsyncHttpClient client = Dsl.asyncHttpClient();
             final OutputStream stream = Files.newOutputStream(tmp.toPath(), new OpenOption[0]);){
            Response resp = (Response)((BoundRequestBuilder)client.preparePost("http://localhost:" + this.port1 + "/").setBody(TestUtils.SIMPLE_TEXT_FILE)).execute((AsyncHandler)new AsyncHandler<Response>(){

                public void onThrowable(Throwable t) {
                }

                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    stream.write(bodyPart.getBodyPartBytes());
                    if (bodyPart.getBodyPartBytes().length == 0) {
                        return AsyncHandler.State.ABORT;
                    }
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) {
                    return AsyncHandler.State.CONTINUE;
                }

                public AsyncHandler.State onHeadersReceived(HttpHeaders headers) {
                    return AsyncHandler.State.CONTINUE;
                }

                public Response onCompleted() {
                    return null;
                }
            }).get();
            Assert.assertNull((Object)resp);
            Assert.assertEquals((long)TestUtils.SIMPLE_TEXT_FILE.length(), (long)tmp.length());
        }
    }

    private class ZeroCopyHandler
    extends AbstractHandler {
        private ZeroCopyHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            byte[] bytes;
            int size = 10240;
            if (httpRequest.getContentLength() > 0) {
                size = httpRequest.getContentLength();
            }
            if ((bytes = new byte[size]).length > 0) {
                httpRequest.getInputStream().read(bytes);
                httpResponse.getOutputStream().write(bytes);
            }
            httpResponse.setStatus(200);
            httpResponse.getOutputStream().flush();
        }
    }
}

